// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: MainWindow.h,v 1.42 2008/08/11 12:23:59 vlg Exp $
//------------------------------------------------------------------------------
//                            MainWindow.h
//------------------------------------------------------------------------------
//  Copyright (c) 2004-2007 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Wed Dec 31 23:18:34 2003
//
//------------------------------------------------------------------------------
#ifndef MAIN_WINDOW_H
#define MAIN_WINDOW_H

#ifdef HAVE_CONFIG_H
#    include "config.h"
#endif

#include "TopMenuBar.h"
#include "DeckManager.h"
#include "CardBox.h"
#include "VDeck.h"

#ifdef IS_HILDON
#    include <hildonmm/window.h>
#    include <gconf/gconf-client.h>
#else
#    include <gtkmm/window.h>
#endif

#include <gtkmm/box.h>
#include <gtkmm/menubar.h>

class PrefWindow;
class CardBoxPrefsWindow;
class AboutGRAPP;
class Deck;

/**===========================================================================**
 *                                                                             *
 *   Nokia N8x0 series defines 2 keyboards with properties.                    *
 *                                                                             *
 **===========================================================================**
 */
#ifdef IS_HILDON

class MaemoKeyboard
{
public:
	class BoolProperty
	{
	public:
		BoolProperty (const string& name_, bool value_ = false)	{
			m_name = name_; m_value = value_;
		}
		
	public:
		string   m_name;
		gboolean m_value;
	};

	typedef std::vector<BoolProperty> properties_type;
	typedef properties_type::iterator properties_iterator;

public:
	MaemoKeyboard ();

	/// Initialize global settings.
	static void s_init ();

	/// Retrieve language configuration
	void fetch_language (int index_);

	/** Retrieve and save default system-wide configuration
	 *  for both keyboards.
	 */
	void save_current_config ();

	/** Disable *wide black* word completion toolbar.
	 */
	void disable_word_completion_toolbar ();

	/** Restore original configuration.
	 */
	void restore_settings ();

private:
	/** Keyboard_2 configuration can be undefined.
	 *  If it is not defined, m_enabled is false.
	 */
	bool            m_enabled;

	string          m_language;
	properties_type m_enforced_cfg;
	properties_type m_original_cfg;

private:
	static const string s_basepath;
	static GConfClient* s_gconf_client;
};

#endif	// @end IS_HILDON

/**===========================================================================**
 *                                                                             *
 *   Class MainWindow                                                          *
 *                                                                             *
 **===========================================================================**
 */
#ifdef IS_HILDON
class MainWindow : public Hildon::Window
#else
class MainWindow : public Gtk::Window
#endif
{
public:
    MainWindow ();
    ~MainWindow ();

    /** Post-c'tor initialization
     */
    void init ();

    // -*- Toolbar Callbacks -*-
    void about_cb   ();

    // [File] Menu
    void pref_cb    ();
    void exit_cb    ();

    // [CardFile] Menu
    void new_cb     ();
    void open_cb    ();
    void open_recent_cb (guint index_);	// set in TopMenuBar
    void save_cb    ();
    void save_as_cb ();
    void export_sound_cb ();
    void close_cb   ();
    void play_in_box (int idx_);
	void cardbox_prefs_cb ();

    // [Deck] Menu
    void unselect_deck_cb ();

    /** Remember window size when resized.
     */
    void size_allocate_cb (Gtk::Allocation& size_);

    void set_mw_name ();

	/** The window will be hidden when the window manager's close button is 
	 *  clicked. We override on_delete_event() to stop this and handle
	 *  exit cleanly.
	 */
	bool on_delete_window_clicked (GdkEventAny* event_);

    DeckManager* get_deck_manager () { return &m_deck_manager; }
    DeckList*    get_deck_list    () { return m_deck_list;     }
    CardBox*     get_cardbox      () { return m_cardbox;       }
    TopMenuBar*  get_top_menubar  () { return &m_top_menu_bar; }

    void  set_dnd_source (Deck* deck_) { m_dnd_source = deck_; }
    Deck* get_dnd_source ()            { return m_dnd_source;  }

	// -*- Friends -*- 
    friend void CardBox::add_deck_to_box  (int idx_, Deck* from_deck_);
    friend void CardBox::move_card_to_box (VDeck::cardlist_iterator card_ref_,
										   int from_deck_, 
										   AnswerQuality answer_quality);
    friend int  CardBox::add_cards_to_box (std::vector<CardRef*>& cardlist_);
    friend void CardBox::mark_as_modified ();
	friend void CardBox::normalize_cards ();

    void dump_mw_state () const;

private:
    // -*- Utilities -*-
    void install_menus_and_toolbar ();

    // -*- Internal actions -*-
    int  open_file    ();
    int  save_file    ();
    int  save_file_as ();
    int  export_sound_bits ();
    void close_file   ();
    void go_state (MWState state_);
    bool change_preferences ();

private:
    static const char* states [];

private:

#ifdef IS_HILDON
	Gtk::Menu      m_main_menu;
	MaemoKeyboard  m_maemo_keyboard [2];  // Nokia IT N8x0 tablet keyboards.
#endif

    MWState              m_state;		// The state of CardFile.
    Gtk::VBox            m_contents;
    DeckManager          m_deck_manager;
    TopMenuBar           m_top_menu_bar;
    Gtk::Widget*         m_open_item;
    string               m_app_title;
    DeckList*            m_deck_list;
    CardBox*             m_cardbox;	// Tray with cardboxes
    PrefWindow*          m_pref_window;
    CardBoxPrefsWindow*  m_cb_prefs_window;
    AboutGRAPP*          m_about;		// 'About' dialog
    Deck*                m_dnd_source;
};

#endif // MAIN_WINDOW_H

