/*
 * Copyright (C) 2010 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of GPXView.
 *
 * GPXView is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GPXView is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GPXView.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include "portrait.h"

static gboolean is_portrait(void) {
  GdkScreen *screen = gdk_screen_get_default();
  return (gdk_screen_get_width(screen) < gdk_screen_get_height(screen));
}

static
void on_orientation_changed(GdkScreen *screen, gpointer userdata) {
  printf("screen size changed\n");

  // adjust vbox/hbox

}

GtkWidget *portrait_box_new(gboolean homogeneous, gint spacing) {
  GtkWidget *box = is_portrait()?
    gtk_vbox_new(homogeneous, spacing):
    gtk_hbox_new(homogeneous, spacing);

  /* this box needs to be re-arranged for portrait mode */
  g_signal_connect(gdk_screen_get_default(), "size-changed", 
		   G_CALLBACK(on_orientation_changed), box);

  return box;
}
