/*
 * Copyright (C) 2010 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of GPXView.
 *
 * GPXView is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GPXView is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GPXView.  If not, see <http://www.gnu.org/licenses/>.
 */

// http://answers.google.com/answers/threadview/id/782886.html

#include "gpxview.h"
#include <time.h>

#define DEG2RAD(a)  ((a)/180.0*M_PI)
#define RAD2DEG(a)  ((a)/M_PI*180.0)

double astro_get_sun_azimuth(appdata_t *appdata) {

  pos_t *pos = gps_get_pos(appdata);
  if(!pos) return NAN;

  time_t now = time(NULL);
  struct tm *tm = gmtime(&now);

  gdouble hourfrac = tm->tm_hour+(tm->tm_min/60.0);

  double g = (360./365.25)*(tm->tm_yday + hourfrac/24);

  g = DEG2RAD(g);
  double D = 0.396372-22.91327*cos(g)+4.02543*sin(g)-0.387205*cos(2*g)+
    +0.051967*sin(2*g)-0.154527*cos(3*g) + 0.084798*sin(3*g);

  double TC = 0.004297+0.107029*cos(g)-1.837877*sin(g)-0.837378*cos(2*g)
    -2.340475*sin(2*g);

  double SHA = (hourfrac-12)*15 + pos->lon + TC;

  double SZA = acos(sin(DEG2RAD(pos->lat))*sin(DEG2RAD(D))+
                  cos(DEG2RAD(pos->lat))*cos(DEG2RAD(D))*cos(DEG2RAD(SHA)));

  if((90.0 - RAD2DEG(SZA)) < 0)
    return NAN;

  double AZ = acos((sin(DEG2RAD(D))-
    sin(DEG2RAD(pos->lat))*cos(SZA))/(cos(DEG2RAD(pos->lat))*sin(SZA)));

  if(hourfrac >= 12.000)
    AZ = 2*M_PI - AZ;

  return AZ;
}
