/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of GPXView.
 *
 * GPXView is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GPXView is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GPXView.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CACHE_H
#define CACHE_H

#include "gcvote.h"

/* number of heading values used max for averaging */
#define MAX_AVERAGE 10 

typedef struct {
  GtkTextBuffer *buffer;
  GtkWidget *latw, *lonw, *overridew, *foundw, *datew, *loggedw;
  gboolean modified;
  time_t ftime;
} notes_context_t;

typedef struct {
  GtkWidget *distance_label, *bearing_label, *eph_label;
  GtkWidget *lat_entry, *lon_entry;

  /* Backing pixmap for drawing area */
  GtkWidget *compass_area;
  GdkPixmap *compass_pixmap;

  guint handler_id;
  pos_t pos;
  float heading, head_avg[MAX_AVERAGE];

  /* things needed for sat view */
  GtkWidget *sat_area;
  GdkPixmap *sat_pixmap;

#ifdef ESPEAK
  guint espeak_handler;
#endif

} goto_context_t;

typedef struct cache_context_s {
  appdata_t *appdata;
  cache_t *cache;
  notes_context_t notes;
  goto_context_t gotoc;

#ifdef USE_STACKABLE_WINDOW
  /* save if the notes are being changed so the cachelist can be redrawn */
  /* if we return to it */
  gboolean notes_have_been_changed;
#endif

  /* widgets in the overview that change when the pos is overwritten */
  GtkWidget *pos_lat_label, *pos_lon_label;
  GtkWidget *bearing_hbox;

  GtkWidget *votes, *quality, *votebox;
  gcvote_request_t *gcvote_request;

#ifdef USE_MAEMO
  guint handler_id;
#endif
} cache_context_t;

void cache_dialog(appdata_t *appdata, cache_t *cache);
GtkWidget *cache_view(appdata_t *appdata, cache_t *cache);

#endif // CACHE_H
