/*
 * Copyright (C) 2009 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of GPXView.
 *
 * GPXView is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GPXView is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GPXView.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GCVOTE_H
#define GCVOTE_H

#define GCVOTE_NONE  -1

#include "gconf.h"

#include <curl/curl.h>
#include <curl/types.h>

/* the full vote structure used during parsing */
typedef struct gcvote_s {
  int quality;
  int votes;
  char *id;
  struct gcvote_s *next;
} gcvote_t;

/* a simple single vote */
typedef struct {
  int quality;
  int votes;
} vote_t;

typedef struct {
  char *ptr;
  int len;
} curl_mem_t;

typedef void (*gcvote_cb)(vote_t *, gpointer data);

/* structure shared between worker and master thread */
typedef struct {
  gint refcount;       /* reference counter for master and worker thread */ 

  char *url, *id;

  /* curl/http related stuff: */
  CURLcode res;

  curl_mem_t mem;   /* used for NET_IO_DL_MEM */

  gcvote_cb cb;
  gpointer userdata;

  /* system proxy settings if present */
  proxy_t *proxy;

} gcvote_request_t;

vote_t *gcvote_restore(appdata_t *appdata, cache_t *cache);
gcvote_request_t *gcvote_request(appdata_t *appdata, gcvote_cb, 
				 char *url, gpointer);
void gcvote_request_free(gcvote_request_t *request);
void gcvote_save(appdata_t *appdata, cache_t *cache, curl_mem_t *mem);

#endif // GCVOTE_H
