/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of GPXView.
 *
 * GPXView is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GPXView is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GPXView.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MISC_H
#define MISC_H

#define SIZE_NORMAL  0
#define SIZE_BIG     1  /* effect only on non-maemo */
#define SIZE_SMALL   2  /* effect only on maemo */

#define STRIKETHROUGH_NONE  0
#define STRIKETHROUGH       1
#define STRIKETHROUGH_RED   2

#ifdef USE_MAEMO
#define GTK_LABEL_BIG(a)  gtk_label_new(a)
#define GTK_LABEL_SMALL(a) gtk_label_small(a)
GtkWidget *gtk_label_small(char *str);
#else
#define GTK_LABEL_SMALL(a) gtk_label_new(a)
#define GTK_LABEL_BIG(a) gtk_label_big(a)
GtkWidget *gtk_label_big(char *str);
#endif

GtkWidget *gtk_label_attrib(char *str, int size, int strikethrough);
GtkWidget *gtk_button_attrib(char *str, int size, int strikethrough);
void gtk_label_attrib_set(GtkWidget *label, 
			  char *str, int size, int strikethrough);

void pos_lat_str(char *str, int len, float latitude); 
void pos_lon_str(char *str, int len, float longitude);
GtkWidget *pos_lat(float latitude, int size, int strikethrough);
GtkWidget *pos_lon(float longitude, int size, int strikethrough);
float pos_parse_lat(char *str);
float pos_parse_lon(char *str);
const char *pos_get_bearing_str(pos_t from, pos_t to);

void textbox_enable(GtkWidget *widget);
void textbox_disable(GtkWidget *widget);

int checkdir(char *dir);
char strlastchr(char *str);

pos_t *get_pos(appdata_t *appdata);

void distance_str(char *str, int len, float dist, gboolean mil);
float distance_parse(char *str, gboolean imperial);

GtkWidget *lat_entry_new(float lat);
GtkWidget *lon_entry_new(float lon);
GtkWidget *dist_entry_new(float dist, gboolean mil);
float lat_get(GtkWidget *widget);
float lon_get(GtkWidget *widget);
float dist_get(GtkWidget *widget, gboolean mil);

#ifndef USE_MAEMO
#ifdef ENABLE_BROWSER_INTERFACE
extern int browser_url(appdata_t *appdata, char *url);
#endif
#endif

#endif // MISC_H
