#include <QLabel>
#include <QVBoxLayout>
#include <QFormLayout>
//#include <QDialogButtonBox>
#include <QPushButton>
#include <QListWidget>
#include <QListWidgetItem>
#include <QStackedWidget>
#include <QTabWidget>
#include <QSpinBox>
#include <QGroupBox>
#include <QCheckBox>
#include <QComboBox>
#include <QSysInfo>
#include <QScrollArea>
#include "config.h"
#include "icons.h"
#include "colorbox.h"
#include "stylecombobox.h"
#include "optionsdialog.h"

#define MENU_MARGIN 20
#define MENU_ICON_SIZE 32


QWidget *OptionsDialog::createAppearancePage()
{
	_baseColor = new ColorBox();
	_baseColor->setColor(_options->palette.color());
	_colorOffset = new QDoubleSpinBox();
	_colorOffset->setMinimum(0);
	_colorOffset->setMaximum(1.0);
	_colorOffset->setSingleStep(0.01);
	_colorOffset->setValue(_options->palette.shift());

	QFormLayout *paletteLayout = new QFormLayout();
	paletteLayout->addRow(tr("Base color:"), _baseColor);
	paletteLayout->addRow(tr("Palette shift:"), _colorOffset);

	QWidget *colorTab = new QWidget();
	colorTab->setLayout(paletteLayout);



    QTabWidget *appearancePage = new QTabWidget();


    QWidget *pathTab = new QWidget();
    QVBoxLayout *verticalLayout_2 = new QVBoxLayout(pathTab);
            verticalLayout_2->setSpacing(6);
            verticalLayout_2->setContentsMargins(11, 11, 11, 11);
            verticalLayout_2->setObjectName(QString::fromUtf8("verticalLayout_2"));
            QScrollArea *scrollArea = new QScrollArea(pathTab);
            scrollArea->setObjectName(QString::fromUtf8("scrollArea"));
            scrollArea->setWidgetResizable(true);
    QWidget *scrollAreaWidgetContents = new QWidget();
    scrollAreaWidgetContents->setObjectName(QString::fromUtf8("scrollAreaWidgetContents"));
    //scrollAreaWidgetContents->setGeometry(QRect(0, 0, 809, 865));
    /*QVBoxLayout *verticalLayout_3 = new QVBoxLayout(scrollAreaWidgetContents);
    verticalLayout_3->setSpacing(6);
    verticalLayout_3->setContentsMargins(11, 11, 11, 11);
    verticalLayout_3->setObjectName(QString::fromUtf8("verticalLayout_3"));*/


    QVBoxLayout *pathTabLayout = new QVBoxLayout(scrollAreaWidgetContents);


    _trackWidth = new QSpinBox(scrollAreaWidgetContents);
    _trackWidth->setValue(_options->trackWidth);
    _trackWidth->setMinimum(1);
    _trackStyle = new StyleComboBox(scrollAreaWidgetContents);
    _trackStyle->setValue(_options->trackStyle);
    QFormLayout *trackLayout = new QFormLayout();
    QLabel *trwidth = new QLabel(scrollAreaWidgetContents);
    QLabel *trstyle = new QLabel(scrollAreaWidgetContents);
    trwidth->setText("Track width:");
    trstyle->setText("Track style:");
    trackLayout->setWidget(0, QFormLayout::LabelRole, trwidth);
    trackLayout->setWidget(0, QFormLayout::FieldRole, _trackWidth);
    trackLayout->setWidget(1, QFormLayout::LabelRole, trstyle);
    trackLayout->setWidget(1, QFormLayout::FieldRole, _trackStyle);
    //trackLayout->addRow(tr("Track width:"), _trackWidth);
    //trackLayout->addRow(tr("Track style:"), _trackStyle);

    _routeWidth = new QSpinBox(scrollAreaWidgetContents);
    _routeWidth->setValue(_options->routeWidth);
    _routeWidth->setMinimum(1);
    _routeStyle = new StyleComboBox(scrollAreaWidgetContents);
    _routeStyle->setValue(_options->routeStyle);
    QFormLayout *routeLayout = new QFormLayout();
    QLabel *rwidth = new QLabel(scrollAreaWidgetContents);
    QLabel *rstyle = new QLabel(scrollAreaWidgetContents);
    rwidth->setText("Route width:");
    rstyle->setText("Route style:");
    routeLayout->setWidget(0, QFormLayout::LabelRole, rwidth);
    routeLayout->setWidget(0, QFormLayout::FieldRole, _routeWidth);
    routeLayout->setWidget(1, QFormLayout::LabelRole, rstyle);
    routeLayout->setWidget(1, QFormLayout::FieldRole, _routeStyle);
    //routeLayout->addRow(tr("Route width:"), _routeWidth);
    //routeLayout->addRow(tr("Route style:"), _routeStyle);

    _pathAA = new QCheckBox(tr("Use anti-aliasing"),scrollAreaWidgetContents);
    _pathAA->setChecked(_options->pathAntiAliasing);
    //QFormLayout *pathAALayout = new QFormLayout();
    //pathAALayout->addWidget(_pathAA);
    //pathTabLayout->addWidget(trackBox);
    //pathTabLayout->addWidget(routeBox);
    //pathTabLayout->addLayout(pathAALayout);
    pathTabLayout->addLayout(trackLayout);
    pathTabLayout->addLayout(routeLayout);
    pathTabLayout->addWidget(_pathAA);
    scrollArea->setWidget(scrollAreaWidgetContents);
    verticalLayout_2->addWidget(scrollArea);
    //verticalLayout_3->addLayout(pathTabLayout);
    //pathTab->setLayout(pathTabLayout);
    //scrollAreaWidgetContents->setLayout(pathTabLayout);
    //QLabel *label = new QLabel(scrollAreaWidgetContents);
    //label->setText("test");
	_graphWidth = new QSpinBox();
	_graphWidth->setValue(_options->graphWidth);
	_graphWidth->setMinimum(1);
	QFormLayout *graphLayout = new QFormLayout();
	graphLayout->addRow(tr("Line width:"), _graphWidth);

	_graphAA = new QCheckBox(tr("Use anti-aliasing"));
	_graphAA->setChecked(_options->graphAntiAliasing);
	QFormLayout *graphAALayout = new QFormLayout();
	graphAALayout->addWidget(_graphAA);


	QWidget *graphTab = new QWidget();
	QVBoxLayout *graphTabLayout = new QVBoxLayout();
	graphTabLayout->addLayout(graphLayout);
	graphTabLayout->addLayout(graphAALayout);
	graphTabLayout->addStretch();
	graphTab->setLayout(graphTabLayout);





	appearancePage->addTab(colorTab, tr("Colors"));
    appearancePage->addTab(scrollAreaWidgetContents, tr("Paths"));
	appearancePage->addTab(graphTab, tr("Graphs"));

	return appearancePage;
}

QWidget *OptionsDialog::createPOIPage()
{
	_poiRadius = new QDoubleSpinBox();
	_poiRadius->setSingleStep(1);
	_poiRadius->setDecimals(1);
	if (_options->units == Imperial) {
		_poiRadius->setValue(_options->poiRadius / MIINM);
		_poiRadius->setSuffix(UNIT_SPACE + tr("mi"));
	} else {
		_poiRadius->setValue(_options->poiRadius / KMINM);
		_poiRadius->setSuffix(UNIT_SPACE + tr("km"));
	}

	QFormLayout *poiLayout = new QFormLayout();
	poiLayout->addRow(tr("POI radius:"), _poiRadius);

	QWidget *poiTab = new QWidget();
	poiTab->setLayout(poiLayout);

	QTabWidget *poiPage = new QTabWidget();
	poiPage->addTab(poiTab, tr("POI"));

	return poiPage;
}

QWidget *OptionsDialog::createExportPage()
{
	_name = new QCheckBox(tr("Name"));
	_name->setChecked(_options->printName);
	_date = new QCheckBox(tr("Date"));
	_date->setChecked(_options->printDate);
	_distance = new QCheckBox(tr("Distance"));
	_distance->setChecked(_options->printDistance);
	_time = new QCheckBox(tr("Time"));
	_time->setChecked(_options->printTime);
	_itemCount = new QCheckBox(tr("Item count (>1)"));
	_itemCount->setChecked(_options->printItemCount);

	QFormLayout *headerTabLayout = new QFormLayout();
	headerTabLayout->addWidget(_name);
	headerTabLayout->addWidget(_date);
	headerTabLayout->addWidget(_distance);
	headerTabLayout->addWidget(_time);
	headerTabLayout->addItem(new QSpacerItem(10, 10));
	headerTabLayout->addWidget(_itemCount);
	QWidget *headerTab = new QWidget();
	headerTab->setLayout(headerTabLayout);


	_separateGraphPage = new QCheckBox(tr("Separate graph page"));
	_separateGraphPage->setChecked(_options->separateGraphPage);

	QFormLayout *graphTabLayout = new QFormLayout();
	graphTabLayout->addWidget(_separateGraphPage);
	QWidget *graphTab = new QWidget();
	graphTab->setLayout(graphTabLayout);


	QTabWidget *exportPage = new QTabWidget();
	exportPage->addTab(headerTab, tr("Header"));
	exportPage->addTab(graphTab, tr("Graphs"));

	return exportPage;
}

QWidget *OptionsDialog::createSystemPage()
{
	_useOpenGL = new QCheckBox(tr("Use OpenGL"));
#ifdef Q_OS_WIN32
	if (QSysInfo::WindowsVersion < QSysInfo::WV_VISTA) {
		_useOpenGL->setChecked(false);
		_useOpenGL->setEnabled(false);
	} else
#endif // Q_OS_WIN32
	_useOpenGL->setChecked(_options->useOpenGL);

	QFormLayout *systemLayout = new QFormLayout();
	systemLayout->addWidget(_useOpenGL);

	QWidget *systemTab = new QWidget();
	systemTab->setLayout(systemLayout);

	QTabWidget *systemPage = new QTabWidget();
	systemPage->addTab(systemTab, tr("System"));

	return systemPage;
}

OptionsDialog::OptionsDialog(Options *options, QWidget *parent)
  : QDialog(parent), _options(options)
{
#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);
    this->showFullScreen();
#endif
	QStackedWidget *pages = new QStackedWidget();
	pages->addWidget(createAppearancePage());
	pages->addWidget(createPOIPage());
    pages->addWidget(createExportPage());
	pages->addWidget(createSystemPage());

	QListWidget *menu = new QListWidget();
	menu->setIconSize(QSize(MENU_ICON_SIZE, MENU_ICON_SIZE));
	new QListWidgetItem(QIcon(QPixmap(APPEARANCE_ICON)), tr("Appearance"),
	  menu);
	new QListWidgetItem(QIcon(QPixmap(POI_ICON)), tr("POI"), menu);
    new QListWidgetItem(QIcon(QPixmap(PRINT_EXPORT_ICON)), tr("Print & Export"), menu);
	new QListWidgetItem(QIcon(QPixmap(SYSTEM_ICON)), tr("System"), menu);

	QHBoxLayout *contentLayout = new QHBoxLayout();
	contentLayout->addWidget(menu);
	contentLayout->addWidget(pages);

	menu->setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Preferred);
	menu->setMaximumWidth(menu->sizeHintForColumn(0) + 2 * menu->frameWidth()
	  + MENU_MARGIN);
	pages->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Preferred);
	pages->setMinimumWidth(2 * menu->size().width());

	connect(menu, SIGNAL(currentRowChanged(int)), pages,
	  SLOT(setCurrentIndex(int)));
	menu->item(0)->setSelected(true);

    QPushButton *buttonOk = new QPushButton;
    QPushButton *buttonCancel = new QPushButton;
    //QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok
     // | QDialogButtonBox::Cancel);
    connect(buttonOk, SIGNAL(clicked()), this, SLOT(accept()));
    connect(buttonCancel, SIGNAL(clicked()), this, SLOT(reject()));

	QVBoxLayout *layout = new QVBoxLayout;
	layout->addLayout(contentLayout);
    QHBoxLayout *hblayout = new QHBoxLayout;
    layout->addLayout(hblayout);
    //layout->addWidget(buttonBox);
    hblayout->addWidget(buttonOk);
    hblayout->addWidget(buttonCancel);
	setLayout(layout);

	setWindowTitle(tr("Options"));
	setWindowFlags(windowFlags() & ~Qt::WindowContextHelpButtonHint);
}

void OptionsDialog::accept()
{
	_options->palette.setColor(_baseColor->color());
	_options->palette.setShift(_colorOffset->value());
	_options->trackWidth = _trackWidth->value();
	_options->trackStyle = (Qt::PenStyle) _trackStyle->itemData(
	  _trackStyle->currentIndex()).toInt();
	_options->routeWidth = _routeWidth->value();
	_options->routeStyle = (Qt::PenStyle) _routeStyle->itemData(
	  _routeStyle->currentIndex()).toInt();
	_options->pathAntiAliasing = _pathAA->isChecked();
	_options->graphWidth = _graphWidth->value();
	_options->graphAntiAliasing = _graphAA->isChecked();

	if (_options->units == Imperial)
		_options->poiRadius = _poiRadius->value() * MIINM;
	else
		_options->poiRadius = _poiRadius->value() * KMINM;

	_options->useOpenGL = _useOpenGL->isChecked();

    /*_options->printName = _name->isChecked();
	_options->printDate = _date->isChecked();
	_options->printDistance = _distance->isChecked();
	_options->printTime = _time->isChecked();
	_options->printItemCount = _itemCount->isChecked();
    _options->separateGraphPage = _separateGraphPage->isChecked();*/

	QDialog::accept();
}
