#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QDir>
#include <QFileSystemWatcher>
#include <QStandardItemModel>
#include <QSortFilterProxyModel>

#include "ui_mainwindow.h"

#include "path.h"

#include "romdelegate.h"

#include "launchdialog.h"
#include "settingsdialog.h"
#include "coredialog.h"
#include "keysdialog.h"
#include "accelerometerdialog.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow();
    ~MainWindow();

private:
    Ui::MainWindow *ui;

    void keyPressEvent(QKeyEvent *e);
    bool eventFilter(QObject *, QEvent *e);

    QStandardItemModel *romModel;
    QSortFilterProxyModel *romProxyModel;
    QFileSystemWatcher *romWatcher;

private slots:
    void listRoms();
    void onRomActivated(QModelIndex index);
    void onSearchTextChanged(QString text);
    void closeSearch();

    void openFile();
    void openSettingsDialog();
    void openCoreDialog();
    void openKeysDialog();
    void openAccelerometerDialog();
};

#endif // MAINWINDOW_H
