#ifndef LAUNCHER_H
#define LAUNCHER_H

#include <QString>
#include <QProcess>
#include <QDir>
#include <QFile>
#include <QTextStream>

#include "path.h"

#include "coreconfig.h"
#include "keysconfig.h"
#include "accelerometerconfig.h"

class Launcher
{
public:
    Launcher(QString romFile,
             CoreConfig *coreConfig,
             KeysConfig *keysConfig,
             AccelerometerConfig *accelerometerConfig);

    void launch();

private:
    QString romFile;

    CoreConfig *coreConfig;
    KeysConfig *keysConfig;
    AccelerometerConfig *accelerometerConfig;

    static QString quote(QString str);
};

#endif // LAUNCHER_H
