#include "launcher.h"

Launcher::Launcher(QString romFile,
                   CoreConfig *coreConfig,
                   KeysConfig *keysConfig,
                   AccelerometerConfig *accelerometerConfig)
{
    this->romFile = romFile;
    this->coreConfig = coreConfig;
    this->keysConfig = keysConfig;
    this->accelerometerConfig = accelerometerConfig;
}

void Launcher::launch()
{
    QString launchPath = Path::appDir();
    QDir().mkpath(launchPath);
    QString launchFilePath = launchPath + "launch";
    QString keysFilePath   = launchPath + "keys";

    // Build the list of arguments
    QStringList cmd;
    cmd << Path::emuExe() << quote(romFile) << "--keys" << keysFilePath;
    if (coreConfig->accelerometer)      cmd << "--accelerometer";
    cmd << "--accelerometer-deadzone" << QString::number(accelerometerConfig->deadzone);
    cmd << "--accelerometer-pitch"    << QString::number(accelerometerConfig->pitch);
    cmd << "--accelerometer-roll"     << QString::number(accelerometerConfig->roll);
    if (accelerometerConfig->calibrate) cmd << "--accelerometer-calibrate";
    if (coreConfig->autopause)          cmd << "--autopause";
    cmd << "--scale"           << QString::number(coreConfig->scale);
    cmd << "--filter"          << QString::number(coreConfig->filter);
    cmd << "--frameskip-type"  << QString::number(coreConfig->frameskipType);
    cmd << "--frameskip-value" << QString::number(coreConfig->frameskipValue);
    if (coreConfig->frameskipRandom)    cmd << "--random-frameskip";
    if (coreConfig->soundDisabled)      cmd << "--no-sound";
    cmd << "--sound-buffer"    << QString::number(coreConfig->soundBuffer);

    QFile launchFile(launchFilePath);
    launchFile.open(QIODevice::WriteOnly | QIODevice::Text | QIODevice::Truncate);

    // Generate a shell script to launch the emulator
    QTextStream(&launchFile)
    << "#!/bin/sh"                    << "\n"
    << "rm " << quote(launchFilePath) << "\n"
    << coreConfig->executeBefore      << "\n"
    << cmd.join(" ")                  << "\n"
    << "rm " << quote(keysFilePath)   << "\n"
    << coreConfig->executeAfter       << "\n";

    launchFile.close();
    launchFile.setPermissions(launchFile.permissions() | QFile::ExeOwner);

    // Generate keys configuration file
    keysConfig->write(keysFilePath);

    // Execute the launcher sript
    QProcess::startDetached(launchFilePath);
}

QString Launcher::quote(QString str)
{
    return "'" + str.replace("'", "'\\''") + "'";
}
