#ifndef LAUNCHDIALOG_H
#define LAUNCHDIALOG_H

#include <QMaemo5Style>

#include "ui_launchdialog.h"

#include "path.h"

#include "rominfo.h"
#include "launcher.h"
#include "coredialog.h"
#include "keysdialog.h"
#include "accelerometerconfig.h"

class LaunchDialog : public QDialog
{
    Q_OBJECT

public:
    LaunchDialog(QFileInfo romFile, QIcon cover, QWidget *parent);
    ~LaunchDialog();

private:
    Ui::LaunchDialog *ui;

    QString romFile;

    CoreConfig coreConfig;
    KeysConfig keysConfig;
    AccelerometerConfig accelerometerConfig;

    void cleanup();

private slots:
    void onStartClicked();
    void onCoreToggled();
    void onKeysToggled();
    void configureCore();
    void configureKeys();
};

#endif // LAUNCHDIALOG_H
