#ifndef ACCELEROMETERWIDGET_H
#define ACCELEROMETERWIDGET_H

#include <QWidget>

#include <QMaemo5Style>

#include <QFile>
#include <QTextStream>
#include <QTimer>
#include <QPainter>

#include <cmath>

class AccelerometerWidget: public QWidget
{
    Q_OBJECT

public:
    AccelerometerWidget(QWidget *parent);

    void resume();
    void suspend();

    void setPortrait(bool portrait);

    float absolutePitch();
    float absoluteRoll();

public slots:
    void setDeadzone(double deadzone);
    void setNeutralPitch(double pitch);
    void setNeutralRoll(double roll);

private:
    static const QPoint directionPoints[8];

    QPixmap background;

    QTimer *readTimer;

    QFile file;

    bool portrait;

    float pitch;
    float roll;

    float deadzone;
    float neutralPitch;
    float neutralRoll;

    void drawDirectionArea(QPainter &painter, int index);

    void paintEvent(QPaintEvent *);

private slots:
    void read();
};

#endif // ACCELEROMETERWIDGET_H
