#include "accelerometerdialog.h"

AccelerometerDialog::AccelerometerDialog(AccelerometerConfig *config, QWidget *parent) :
    RotatingDialog(parent),
    ui(new Ui::AccelerometerDialog)
{
    ui->setupUi(this);

    this->setAttribute(Qt::WA_DeleteOnClose);

    this->config = config;

    ui->dialogLayout->itemAt(0)->setAlignment(Qt::AlignCenter);

    connect(ui->deadzoneBox, SIGNAL(valueChanged(double)), ui->accelerometerWidget, SLOT(setDeadzone(double)));
    connect(ui->pitchBox, SIGNAL(valueChanged(double)), ui->accelerometerWidget, SLOT(setNeutralPitch(double)));
    connect(ui->rollBox,  SIGNAL(valueChanged(double)), ui->accelerometerWidget, SLOT(setNeutralRoll(double)));
    connect(ui->pitchButton, SIGNAL(clicked()), this, SLOT(detectPitch()));
    connect(ui->rollButton,  SIGNAL(clicked()), this, SLOT(detectRoll()));

    load();

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(onOrientationChanged()));

    onOrientationChanged();
}

AccelerometerDialog::~AccelerometerDialog()
{
    save();

    delete ui;
}

void AccelerometerDialog::onOrientationChanged()
{
    QRect screen = QApplication::desktop()->screenGeometry();

    if (screen.width() > screen.height()) {
        // Landscape
        ui->dialogLayout->setDirection(QBoxLayout::LeftToRight);
        ui->accelerometerWidget->setPortrait(false);
    } else {
        // Portrait
        ui->dialogLayout->setDirection(QBoxLayout::TopToBottom);
        ui->accelerometerWidget->setPortrait(true);
    }

    this->adjustSize();
}

void AccelerometerDialog::detectPitch()
{
    ui->pitchBox->setValue(ui->accelerometerWidget->absolutePitch());
}

void AccelerometerDialog::detectRoll()
{
    ui->rollBox->setValue(ui->accelerometerWidget->absoluteRoll());
}

void AccelerometerDialog::changeEvent(QEvent *)
{
    if (this->isActiveWindow()) {
        ui->accelerometerWidget->resume();
    } else {
        ui->accelerometerWidget->suspend();
    }
}

void AccelerometerDialog::load()
{
    ui->calibrateBox->setChecked(config->calibrate);
    ui->deadzoneBox->setValue(config->deadzone);
    ui->pitchBox->setValue(config->pitch);
    ui->rollBox->setValue(config->roll);
}

void AccelerometerDialog::save()
{
    config->calibrate = ui->calibrateBox->isChecked();
    config->deadzone  = ui->deadzoneBox->value();
    config->pitch     = ui->pitchBox->value();
    config->roll      = ui->rollBox->value();

    config->save();
}
