#ifndef ACCELEROMETERCONFIG_H
#define ACCELEROMETERCONFIG_H

#include "abstractconfig.h"

#include "path.h"

#define DEFAULT_Deadzone 10
#define DEFAULT_Pitch 0
#define DEFAULT_Roll  0
#define DEFAULT_Calibrate false

class AccelerometerConfig : public AbstractConfig
{
public:
    float deadzone; // --accelerometer-deadzone
    float pitch;    // --accelerometer-pitch
    float roll;     // --accelerometer-roll
    bool calibrate; // --accelerometer-calibrate

    AccelerometerConfig(QString file = QString());

    void save();

private:
    QString group() { return "Accelerometer"; }

    bool load(QString file);
};

#endif // ACCELEROMETERCONFIG_H
