#include "accelerometerconfig.h"

// Construct and bind to a file
AccelerometerConfig::AccelerometerConfig(QString file) : AbstractConfig(file)
{
    // Load from the bound file
    if (!load(file))
        // Fall back to the global configuration
        load(Path::cfgFile());
}

// Load settings from a native file
bool AccelerometerConfig::load(QString file)
{
    QSettings settings(file, QSettings::IniFormat);

    settings.beginGroup(group());

    deadzone  = settings.value("Deadzone" , DEFAULT_Deadzone ).toFloat();
    pitch     = settings.value("Pitch"    , DEFAULT_Pitch    ).toFloat();
    roll      = settings.value("Roll"     , DEFAULT_Roll     ).toFloat();
    calibrate = settings.value("Calibrate", DEFAULT_Calibrate).toBool();

    // The check is performed after loading so that at least the defaults are in place
    settings.endGroup();
    return exists(settings);
}

// Save settings to the bound file
void AccelerometerConfig::save()
{
    QSettings settings(file, QSettings::IniFormat);

    settings.beginGroup(group());

    settings.setValue("Deadzone",  deadzone);
    settings.setValue("Pitch",     pitch);
    settings.setValue("Roll",      roll);
    settings.setValue("Calibrate", calibrate);
}
