#include "rotatingdialog.h"

RotatingDialog::RotatingDialog(QWidget *parent) : QDialog(parent)
{
    // Device rotation perceived as resizing of the desktop
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(resize()));
}

void RotatingDialog::showEvent(QShowEvent *e)
{
    resize();

    QDialog::showEvent(e);
}

void RotatingDialog::resize()
{
    // Force the dialog to be at least the preferred size
    this->setMinimumSize(this->sizeHint());
    // Make the resizing actually happen
    this->adjustSize();
}
