#include "bindbutton.h"

BindButton::BindButton(QString text, int code, QWidget *parent) :
    QMaemo5ValueButton(text, parent)
{
    this->setValueLayout(QMaemo5ValueButton::ValueUnderTextCentered);
    this->setContextMenuPolicy(Qt::DefaultContextMenu);
    this->setCheckable(true);

    connect(this, SIGNAL(toggled(bool)), this, SLOT(onToggled(bool)));

    setKeyCode(code);
}

int BindButton::keyCode()
{
    return code;
}

void BindButton::setKeyCode(int code)
{
    this->code = code;

    if (code) {
        Display *display = XOpenDisplay(NULL);
        char *keysym = XKeysymToString(XKeycodeToKeysym(display, code, 0));
        this->setValueText(keysym ? keysym : QString::number(code));
        XCloseDisplay(display);
    } else {
        this->setValueText("(unbound)");
    }
}

void BindButton::grabZoomKeys(bool grab)
{
    uchar data = grab;

    XChangeProperty(QX11Info::display(), this->winId(),
                    XInternAtom(QX11Info::display(), "_HILDON_ZOOM_KEY_ATOM", false),
                    XA_INTEGER, 32, PropModeReplace, &data, 1);
}

void BindButton::keyPressEvent(QKeyEvent *e)
{
    if (this->isChecked()) {
        setKeyCode(e->nativeScanCode());
        this->setChecked(false);
    } else {
        e->ignore();
    }
}

void BindButton::contextMenuEvent(QContextMenuEvent*)
{
    setKeyCode(0);

    // This maneuver snatches the button from under the finger to reset the half-click
    this->hide();
    this->show();
}

void BindButton::onToggled(bool checked)
{
    if (checked) {
        // Uncheck other buttons in the group
        foreach(QAbstractButton *button, this->group()->buttons())
            if (button != this)
                button->setChecked(false);

        this->grabKeyboard();
        this->setValueText("???");
        grabZoomKeys(true);
    } else {
        this->releaseKeyboard();
        this->setKeyCode(code);
        grabZoomKeys(false);
    }
}
