#include "keysdialog.h"

KeysDialog::KeysDialog(KeysConfig *config, QWidget *parent) :
    RotatingDialog(parent),
    ui(new Ui::KeysDialog)
{
    ui->setupUi(this);

    this->setAttribute(Qt::WA_DeleteOnClose);

    this->config = config;

    QPalette palette = ui->helpInfo->palette();
    palette.setColor(QPalette::WindowText, QMaemo5Style::standardColor("SecondaryTextColor"));
    ui->helpInfo->setPalette(palette);

    load();
}

KeysDialog::~KeysDialog()
{
    save();

    delete ui;
}

void KeysDialog::load()
{
    QButtonGroup *buttonGroup = new QButtonGroup(this);
    // BindButton provides its own, more suitable exclusion
    buttonGroup->setExclusive(false);

    for (int i = 0; i < KeysConfig::KEY_COUNT; i++) {
        BindButton *button = new BindButton(KeysConfig::displayName[i], config->code[i], this);
        ui->mainLayout->addWidget(button, 1 + i/2, i%2);
        buttonGroup->addButton(button);
    }
}

void KeysDialog::save()
{
    for (int i = 0; i < KeysConfig::KEY_COUNT; i++) {
        BindButton *button = qobject_cast<BindButton*>(ui->mainLayout->itemAt(1 + i)->widget());
        config->code[i] = button ? button->keyCode() : 0;
    }

    config->save();
}
