#ifndef KEYSCONFIG_H
#define KEYSCONFIG_H

#include "abstractconfig.h"

#include "path.h"

#include <QTextStream>

class KeysConfig : public AbstractConfig
{
public:
    // The order has to be matched with 1) gpspm and 2) names in the cpp file
    // TODO: Make neater enum-string mapping?
    enum {
        Up,
        Down,
        Left,
        Right,
        Start,
        Select,
        A,
        B,
        L,
        R,
        Left_Up,
        Right_Up,
        Left_Down,
        Right_Down,
        LoadState,
        SaveState,
        FastForward,
        ShowFPS,
        Quit,
        Pause,
        KEY_COUNT
    };

    static const char* name[KEY_COUNT];
    static const char* displayName[KEY_COUNT];

    int code[KEY_COUNT];

    KeysConfig(QString file = QString());

    void save();
    void write(QString file);

private:
    QString group() { return "Keys"; }

    bool load(QString file);
    bool read(QString file);
};

#endif // KEYSCONFIG_H
