#include "coreconfig.h"

// Construct and bind to a file
CoreConfig::CoreConfig(QString file) : AbstractConfig(file)
{
    // Load from the bound file
    if (!load(file))
        // Fall back to the global configuration
        load(Path::cfgFile());
}

// Load settings from a native file
bool CoreConfig::load(QString file)
{
    QSettings settings(file, QSettings::IniFormat);

    settings.beginGroup(group());

    accelerometer   = settings.value("Accelerometer"  , DEFAULT_Accelerometer  ).toBool();
    autopause       = settings.value("Autopause"      , DEFAULT_Autopause      ).toBool();
    scale           = settings.value("Scale"          , DEFAULT_Scale          ).toInt();
    frameskipType   = settings.value("FrameskipType"  , DEFAULT_FrameskipType  ).toInt();
    frameskipValue  = settings.value("FrameskipValue" , DEFAULT_FrameskipValue ).toInt();
    frameskipRandom = settings.value("FrameskipRandom", DEFAULT_FrameskipRandom).toBool();
    soundDisabled   = settings.value("SoundDisabled"  , DEFAULT_SoundDisabled  ).toBool();
    soundBuffer     = settings.value("SoundBuffer"    , DEFAULT_SoundBuffer    ).toInt();
    executeBefore   = settings.value("ExecuteBefore"  , DEFAULT_ExecuteBefore  ).toString();
    executeAfter    = settings.value("ExecuteAfter"   , DEFAULT_ExecuteAfter   ).toString();

    // The check is performed after loading so that at least the defaults are in place
    settings.endGroup();
    return exists(settings);
}

// Save settings to the bound file
void CoreConfig::save()
{
    QSettings settings(file, QSettings::IniFormat);

    settings.beginGroup(group());

    settings.setValue("Accelerometer"  , accelerometer);
    settings.setValue("Autopause"      , autopause);
    settings.setValue("Scale"          , scale);
    settings.setValue("FrameskipType"  , frameskipType);
    settings.setValue("FrameskipValue" , frameskipValue);
    settings.setValue("FrameskipRandom", frameskipRandom);
    settings.setValue("SoundDisabled"  , soundDisabled);
    settings.setValue("SoundBuffer"    , soundBuffer);
    settings.setValue("ExecuteBefore"  , executeBefore);
    settings.setValue("ExecuteAfter"   , executeAfter);
}
