#include "options.h"

QStringList current_config=QStringList();
QString current_core="";
options::options(QWidget *parent) :    QWidget(parent)
{
	#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
	#endif
    this->setWindowFlags(this->windowFlags() | Qt::Window);
    this->setContentsMargins(0,0,0,0);
    QVBoxLayout *lay2=new QVBoxLayout(this);

    QScrollArea *area=new QScrollArea(this);
    QWidget *wgt=new QWidget(area);
    wgt->show();
    wgt->setMinimumHeight(640);
    wgt->setMinimumWidth(750);
    area->setWidget(wgt);
    lay2->addWidget(area);
    QGridLayout *lay=new QGridLayout(wgt);
    chkAccel=new QCheckBox("Enabled",this);
    cmbScreen=new QComboBox(this);
    cmbScreen->addItems(QStringList()<<"no scale"<<"double scale"<<"triple scale"<<"fullscreen");
    chkNoSound=new QCheckBox("Enabled",this);
    cmbFrameskip=new QComboBox(this);
    cmbFrameskip->addItems(QStringList()<<"Off"<<"Auto"<<"Manual");
    numFrameskipValue=new QSpinBox(this);
    numFrameskipValue->setRange(0,15);
    cmbFsType=new QComboBox(this);
    cmbFsType->addItem("uniform");cmbFsType->addItem("random");
    cmbSoundBuffer=new QComboBox(this);
    cmbSoundBuffer->addItems(QStringList()<<"16 bytes"<<"32 bytes"<<"64 bytes"<<
                                            "128 bytes"<< "256 bytes"<< "512 bytes"<< "1024 bytes"<< "2048 bytes"<<
                                            "4096 bytes"<< "8192 bytes"<< "16284 bytes");
    chkAccel->show();cmbScreen->show();
    chkNoSound->show();
    cmbFrameskip->show();
    numFrameskipValue->show();
    cmbFsType->show();
    cmbSoundBuffer->show();
    lay->addWidget(new QLabel(tr("Accelerometer"), this), 0, 0);
    lay->addWidget(chkAccel, 0, 1);
    lay->addWidget(new QLabel(tr("Screen"), this), 1, 0);
    lay->addWidget(cmbScreen, 1, 1);
    lay->addWidget(new QLabel(tr("No sound"), this), 2, 0);
    lay->addWidget(chkNoSound, 2, 1);
    lay->addWidget(new QLabel(tr("Frameskip"), this), 3, 0);
    lay->addWidget(cmbFrameskip, 3, 1);
    lay->addWidget(new QLabel(tr("Value"), this), 4, 0);
    lay->addWidget(numFrameskipValue, 4, 1);
    lay->addWidget(new QLabel(tr("Fs Type"), this), 5, 0);
    lay->addWidget(cmbFsType, 5, 1);
    lay->addWidget(new QLabel(tr("Sound buffer"), this), 6, 0);
    lay->addWidget(cmbSoundBuffer, 6, 1);

    connect(cmbFrameskip, SIGNAL(currentIndexChanged(QString)), this, SLOT(frameskipChanged(QString)));
    load_cfg();
}

options::~options(){

}

void options::hideEvent(QHideEvent *){
    if (!this->isVisible()){
        QDialog *dlg=new QDialog(this);
        QGridLayout *lay=new QGridLayout(dlg);
        QLabel *lbl=new QLabel(tr("Do you want to save settings?"),dlg);
        lay->addWidget(lbl,1,0,1,2);
        QPushButton *yes=new QPushButton(tr("Yes"),dlg);
        QPushButton *no=new QPushButton(tr("No"),dlg);
        connect (yes,SIGNAL(clicked()),dlg,SLOT(accept()));
        connect (no,SIGNAL(clicked()),dlg,SLOT(reject()));
        connect (dlg,SIGNAL(accepted()),this,SLOT(save_cfg()));
        lay->addWidget(yes,2,0);
        lay->addWidget(no ,2,1);
        dlg->exec();
    }
}

void options::load_cfg(){
    QString path="";
    if (game!="")
        path=cfg_path+game;
    else
       path=cfg_path+"default";
    QStringList configs=QStringList()<<"accel"<<"screen"<<"nosound"
                 <<"fskip"<<"fskip_value"<<"fstype"<<"sound_buffer";

    if (QFile::exists(path)){

        QFile file(path);
        if (!file.open(QIODevice::ReadOnly | QIODevice::Text)){
            qDebug(QString("Can't open file : %1\n").arg(path).toAscii());
            return;
        }
        cmbScreen->setCurrentIndex(2);
        cmbFrameskip->setCurrentIndex(1);
        numFrameskipValue->setValue(10);
        cmbSoundBuffer->setCurrentIndex(8);

         QTextStream in(&file);
         while (!in.atEnd()) {
             QStringList line = QString(in.readLine()).split("=");
             QString value=line.at(1);
             switch (configs.indexOf(line.at(0).trimmed())){
             case 0:
                 if (value=="1")chkAccel->setChecked(true);
                 break;
             case 1:
                 cmbScreen->setCurrentIndex(value.toInt());
                 break;
             case 2:
                 if (value=="1")chkNoSound->setChecked(true);
                     break;
             case 3:
                cmbFrameskip->setCurrentIndex(value.toInt());
                 break;
             case 4:
                 numFrameskipValue->setValue(value.toInt());
                 break;
             case 5:
                cmbFsType->setCurrentIndex(value.toInt());
                 break;
             case 6:
                cmbSoundBuffer->setCurrentIndex(value.toInt());
             case 7:

                 break;
             default:
                  qDebug(QString("Undefined setting:%1 = %2").arg(line.at(0)).arg(value).toAscii());
                  break;
             }
         }
         file.close();
         createCfg();
    }
}


void options::createCfg(){
   current_config=QStringList();


    if (chkAccel->isChecked())current_config<<"-accel";
    current_config<<"-screen"<<QString("%1").arg(cmbScreen->currentIndex());
    if (chkNoSound->isChecked())current_config<<"-nosound";
    current_config<<"-fskip"<<QString("%1").arg(cmbFrameskip->currentIndex());
    current_config<<"-fskip_value"<<QString("%1").arg(numFrameskipValue->value());
    current_config<<"-fstype"<<QString("%1").arg(cmbFsType->currentIndex());
    current_config<<"-sound_buffer"<<QString("%1").arg(cmbSoundBuffer->currentIndex());
	current_config<<"-cdfile";

}

void options::save_cfg(){
    createCfg();
    QString path="";
    if (game!="")
        path=cfg_path+game;
    else
       path=cfg_path+"default";

    //gpsp -cdfile file.gba [-breack a][-accel][-screen b][-nosound][-fskip c][-fskip_value d][-fstype e][-sound_buffer f]\n
    QString config=QString(
                   "accel=%1\n" \
                   "screen=%2\n" \
                   "nosound=%3\n" \
                   "fskip=%4\n" \
                   "fskip_value=%5\n" \
                   "fstype=%6\n" \
                   "sound_buffer=%7\n"
                   )
            .arg(chkAccel->isChecked()?"1":"0")
            .arg(cmbScreen->currentIndex())
            .arg(chkNoSound->isChecked()?"1":"0")
            .arg(cmbFrameskip->currentIndex())
            .arg(numFrameskipValue->value())
            .arg(cmbFsType->currentIndex())
            .arg(cmbSoundBuffer->currentIndex())

;

    QFile file(path);
    if (!file.open(QIODevice::WriteOnly | QIODevice::Text)){
        qDebug(QString("Can't save %1").arg(path).toAscii());
        return;
    }
    QTextStream out(&file);
    out <<config;

    file.close();

}

void options::frameskipChanged(QString value)
{
    numFrameskipValue->setEnabled(value == "Manual");
}
