#include "loadprev.h"

loadPrev::loadPrev(QWidget *parent) :
    QWidget(parent)
{
	#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(this->windowFlags() | Qt::Window);
	#endif

}

void loadPrev::init(QStringList args_n,QString core_n,QString rom_n,QList<int>)
{
rom=rom_n;
args=args_n;
core=core_n;
state=0;
    QHBoxLayout *laym=new QHBoxLayout(this);

laym->setContentsMargins(560,20,10,20);

 QVBoxLayout *lay=new QVBoxLayout();
 QVBoxLayout *lay2=new QVBoxLayout();
 laym->addLayout(lay);
 laym->addLayout(lay2);

int d=0;
for(int st=0;st<9;st++){
        QPushButton *btn=new QPushButton;
        btn->setText(QString("%1").arg(st));

        if (d++<5)
            lay->addWidget(btn);
        else
           lay2->addWidget(btn);

        connect(btn,SIGNAL(clicked()),this,SLOT(slot_click()));
    }


    QPushButton *btn=new QPushButton("LOAD");
     lay2->addWidget(btn);
    connect(btn,SIGNAL(clicked()),this,SLOT(load_click()));


    this->show();
    img.load(QString("/opt/maemo/usr/games/screenshots/%1.%2").arg(rom.split("/").last()).arg(state,3,10,QChar('0')),"png");
    this->update();
}

loadPrev::~loadPrev()
{

}
void loadPrev::paintEvent(QPaintEvent *){
    QPainter painter(this);
    painter.drawImage(QRect(0,0,560,420),img);
}

void loadPrev::slot_click(){
    QPushButton *btn = qobject_cast<QPushButton *>(sender());
    state=btn->text().toInt();
    bool ok=img.load(QString("/opt/maemo/usr/games/screenshots/%1.%2").arg(rom.split("/").last()).arg(state,3,10,QChar('0')),"png");
    if (!ok)
        img.load("/opt/psx4m/no_data.png","png");
    this->update();
}

void loadPrev::load_click(){

    QProcess *myProcess = new QProcess();
    args<<rom<<"-load"<<QString("%1").arg(state+1)<<"-save_name"<<rom.split("/").last();

    qDebug (QString("%1 %2").arg("/opt/maemo/usr/games/"+core)
            .arg(args.join(" ")).toAscii());

    myProcess->startDetached("/opt/maemo/usr/games/"+core, args,"/home/user/");
    this->close();

}
