#include "options.h"

QStringList current_config=QStringList();
QString current_core="";
options::options(QWidget *parent) :    QWidget(parent)
{
	#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
	#endif
    this->setWindowFlags(this->windowFlags() | Qt::Window);
    QVBoxLayout *lay2=new QVBoxLayout(this);

    QScrollArea *area=new QScrollArea(this);
    QWidget *wgt=new QWidget(area);
    wgt->show();
    wgt->setMinimumHeight(640);
    wgt->setMinimumWidth(780);
    area->setWidget(wgt);
    lay2->addWidget(area);
    QVBoxLayout *lay=new QVBoxLayout(wgt);
    a=new QCheckBox("Accelometer",this);
    b=new QComboBox(this); b->addItems(QStringList()<<"no scale"<<"double scale"<<"triple scale"<<"fullscreen");
    c=new QCheckBox("No sound",this);
    d=new QComboBox(this);d->addItems(QStringList()<<"Off"<<"Auto"<<"Manual");
    e=new QSpinBox(this);e->setRange(0,15);
    f=new QComboBox(this);f->addItem("uniform");f->addItem("random");
    g=new QComboBox(this);g->addItems(QStringList()<<"16 bytes"<<"32 bytes"<<"64 bytes"<<
    "128 bytes"<< "256 bytes"<< "512 bytes"<< "1024 bytes"<< "2048 bytes"<<
    "4096 bytes"<< "8192 bytes"<< "16284 bytes");
    a->show();b->show();c->show();d->show();e->show();f->show();g->show();
    lay->addWidget(a);
    lay->addWidget(b);
    lay->addWidget(c);
    lay->addWidget(d);
    lay->addWidget(e);
    lay->addWidget(f);
    lay->addWidget(g);

                 load_cfg();

}

options::~options()
{

}
void options::hideEvent(QHideEvent *){
    if (!this->isVisible()){
        QDialog *dlg=new QDialog(this);
        QGridLayout *lay=new QGridLayout(dlg);
        QLabel *lbl=new QLabel(tr("Do you want to save settings?"),dlg);
        lay->addWidget(lbl,1,0,1,2);
        QPushButton *yes=new QPushButton(tr("Yes"),dlg);
        QPushButton *no=new QPushButton(tr("No"),dlg);
        connect (yes,SIGNAL(clicked()),dlg,SLOT(accept()));
        connect (no,SIGNAL(clicked()),dlg,SLOT(reject()));
        connect (dlg,SIGNAL(accepted()),this,SLOT(save_cfg()));
        lay->addWidget(yes,2,0);
        lay->addWidget(no ,2,1);
        dlg->exec();
    }
}

void options::load_cfg(){
    QString path="";
    if (game!="")
        path=cfg_path+game;
    else
       path=cfg_path+"default";
    QStringList configs=QStringList()<<"accel"<<"screen"<<"nosound"
                 <<"fskip"<<"fskip_value"<<"fstype"<<"sound_buffer";

    if (QFile::exists(path)){

        QFile file(path);
        if (!file.open(QIODevice::ReadOnly | QIODevice::Text)){
            qDebug(QString("Can't open file : %1\n").arg(path).toAscii());
            return;
        }
b->setCurrentIndex(2);
d->setCurrentIndex(1);
e->setValue(10);
g->setCurrentIndex(8);

             QTextStream in(&file);
             while (!in.atEnd()) {
                 QStringList line = QString(in.readLine()).split("=");
                 QString value=line.at(1);
                 switch (configs.indexOf(line.at(0).trimmed())){
                 case 0:
                     if (value=="1")a->setChecked(true);
                     break;
                 case 1:
                     b->setCurrentIndex(value.toInt());
                     break;
                 case 2:
                     if (value=="1")c->setChecked(true);
                         break;
                 case 3:
                    d->setCurrentIndex(value.toInt());
                     break;
                 case 4:
                     e->setValue(value.toInt());
                     break;
                 case 5:
f->setCurrentIndex(value.toInt());
                     break;
                 case 6:
g->setCurrentIndex(value.toInt());
                 case 7:

                     break;
                 default:
                      qDebug(QString("Undefined setting:%1 = %2").arg(line.at(0)).arg(value).toAscii());
                      break;
                 }
             }
             file.close();
             createCfg();
    }
}


void options::createCfg(){
   current_config=QStringList();


    if (a->isChecked())current_config<<"-accel";
    current_config<<"-screen"<<QString("%1").arg(b->currentIndex());
    if (c->isChecked())current_config<<"-nosound";
    current_config<<"-fskip"<<QString("%1").arg(d->currentIndex());
    current_config<<"-fskip_value"<<QString("%1").arg(e->value());
    current_config<<"-fstype"<<QString("%1").arg(f->currentIndex());
    current_config<<"-sound_buffer"<<QString("%1").arg(g->currentIndex());
	current_config<<"-cdfile";

}

void options::save_cfg(){
    createCfg();
    QString path="";
    if (game!="")
        path=cfg_path+game;
    else
       path=cfg_path+"default";

    //gpsp -cdfile file.gba [-breack a][-accel][-screen b][-nosound][-fskip c][-fskip_value d][-fstype e][-sound_buffer f]\n
    QString config=QString(
                   "accel=%1\n" \
                   "screen=%2\n" \
                   "nosound=%3\n" \
                   "fskip=%4\n" \
                "fskip_value=%5\n" \
                "fstype=%6\n" \
                "sound_buffer=%7\n"
                   )
            .arg(a->isChecked()?"1":"0")
            .arg(b->currentIndex())
            .arg(c->isChecked()?"1":"0")
            .arg(d->currentIndex())
            .arg(e->value())
            .arg(f->currentIndex())
            .arg(g->currentIndex())

;

    QFile file(path);
    if (!file.open(QIODevice::WriteOnly | QIODevice::Text)){
        qDebug(QString("Can't save %1").arg(path).toAscii());
        return;}

         QTextStream out(&file);
         out <<config;

         file.close();

}


