#ifndef UTIL_H
#define UTIL_H

/*
  GPSJinni - show raw data from the GPS subsystem.
  Copyright (C) 2010  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <string>

extern std::wstring DoubleToString(double value, int precision = 2);

extern std::wstring GetSpeedNoDataUnit();
extern std::wstring GetSpeedAsString(double metric);
extern std::wstring GetSpeedUnitAsString(double metric);
extern std::wstring GetSpeedAndUnitAsString(double metric);
extern std::wstring GetSpeedAndUnitAsString(double metric, double dev);

extern std::wstring GetMetricAndUnitAsString(double metric);
extern std::wstring GetMetricAndUnitAsString(double metric, double dev);

extern std::wstring GetAngleAsDegreeMinuteSecondString(double angle360,
                                          const wchar_t *negativePrefix = L"-",
                                          const wchar_t *positivePrefix = L"+",
                                          int secondPrecision = 2);

extern double CalculateWeightedDirection(double oldAngle,
                                         double newAngle,
                                         double newWeight0to1,
                                         double fullCircleAngle = 360);

#endif
