#ifndef GPSDATA_H
#define GPSDATA_H

/*
  GPSJinni - show raw data from the GPS subsystem.
  Copyright (C) 2009  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <vector>

#include <Lum/Base/DateTime.h>

class GPSData
{
public:
  struct Satellite
  {
    int  id;
    bool used;
    int  snr;
  };

private:
  bool                   connected;
  Lum::Base::SystemTime  connectedLastData;

  bool                   online;
  Lum::Base::SystemTime  onlineLastData;

  bool                   fix;
  Lum::Base::SystemTime  fixLastData;

  double                 latitude;
  double                 latitudeDev;
  Lum::Base::SystemTime  latitudeLastData;

  double                 longitude;
  double                 longitudeDev;
  Lum::Base::SystemTime  longitudeLastData;

  double                 altitude;
  double                 altitudeDev;
  Lum::Base::SystemTime  altitudeLastData;

  double                 speed;
  double                 speedDev;
  Lum::Base::SystemTime  speedLastData;

  double                 track;
  double                 trackDev;
  Lum::Base::SystemTime  trackLastData;

  double                 climb;
  double                 climbDev;
  Lum::Base::SystemTime  climbLastData;

  Lum::Base::SystemTime  time;
  double                 timeDev;
  Lum::Base::SystemTime  timeLastData;

  std::vector<Satellite> satellites;
  Lum::Base::SystemTime  satellitesLastData;

public:
  GPSData();

  //
  // Connected
  //
  void SetConnected(bool connected);
  bool HasConnected() const;
  bool GetConnected() const;

  //
  // Online
  //
  void SetOnline(bool online);
  bool HasOnline() const;
  bool GetOnline() const;

  //
  // Fix
  //
  void SetFix(bool fix);
  bool HasFix() const;
  bool GetFix() const;

  //
  // Latitude
  //
  void SetLatitude(double latitude,
                   double latitudeDev);
  bool HasLatitude() const;
  double GetLatitude() const;
  double GetLatitudeDev() const;

  //
  // Longitude
  //
  void SetLongitude(double longitude,
                    double longitudeDev);
  bool HasLongitude() const;
  double GetLongitude() const;
  double GetLongitudeDev() const;

  //
  // Altitude
  //
  void SetAltitude(double altitude,
                   double altitudeDev);
  bool HasAltitude() const;
  double GetAltitude() const;
  double GetAltitudeDev() const;

  //
  // Speed
  //
  void SetSpeed(double speed,
                double speedDev);
  bool HasSpeed() const;
  double GetSpeed() const;
  double GetSpeedDev() const;

  //
  // Track
  //
  void SetTrack(double track,
                double trackDev);
  bool HasTrack() const;
  double GetTrack() const;
  double GetTrackDev() const;

  //
  // Climb
  //
  void SetClimb(double climb,
                double climbDev);
  bool HasClimb() const;
  double GetClimb() const;
  double GetClimbDev() const;

  //
  // Time
  //
  void SetTime(Lum::Base::SystemTime& time,
               double timeDev);
  bool HasTime() const;
  Lum::Base::SystemTime GetTime() const;
  double GetTimeDev() const;

  //
  // Satellites
  //
  void SetSatellites(const std::vector<Satellite>& satellites);
  bool HasSatellites() const;
  const std::vector<Satellite>& GetSatellites() const;
};

#endif

