#ifndef TRACKS_H
#define TRACKS_H

/*
  GPSJinni - show raw data from the GPS subsystem.
  Copyright (C) 2010  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <fstream>
#include <string>

#include <Lum/Base/DateTime.h>

#include <Lum/Model/Table.h>

#include <Lum/OS/Window.h>

#include "GPSData.h"

class Track
{
private:
  std::wstring          name;
  Lum::Base::SystemTime time;

public:
  Track()
  {
    // no code
  }

  Track(const std::wstring& name, const Lum::Base::SystemTime& time)
  : name(name),
    time(time)
  {
    // no code
  }

  std::wstring GetName() const
  {
    return name;
  }

  std::wstring GetTimeString() const
  {
    return time.GetLocalLocaleDate()+L" "+time.GetLocalLocaleTime();
  }
};

typedef Lum::Model::StdTable<Track> TracksModel;
typedef Lum::Base::Reference<TracksModel> TracksModelRef;

extern bool StartTracking(Lum::OS::Window* parent,
                          std::ofstream& trackFile);
extern bool AddTrackingRecord(std::ofstream& trackFile,
                              const GPSData& data);
extern bool DeleteTrack(Lum::OS::Window* parent,
                        const std::wstring& name);
extern unsigned long GetFileSize(std::ofstream& trackFile);

extern void RefreshTracks(TracksModel* tracks);
extern void ExportTrackToKML(Lum::OS::Window* parent,
                             const std::wstring& name);
extern void ExportTrackToGPX(Lum::OS::Window* parent,
                             const std::wstring& name);


#endif
