/*
  This source is part of the GPSJinni program.
  Copyright (C) 2010  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "Settings.h"

#include <Lum/Base/L10N.h>

#include <Lum/OS/Manager/Repository.h>

#include <Lum/Label.h>
#include <Lum/Panel.h>
#include <Lum/ValueButton.h>

#include "Configuration.h"

Settings::Settings()
 : okAction(new Lum::Model::Action())
{
  Observe(okAction);

  Observe(unitMode);
  
  unitMode->Push();
}

Settings::~Settings()
{
  unitMode->Pop();
}

Lum::Object* Settings::GetContent()
{
  Lum::Model::StringTableRef unitModeChoices(new Lum::Model::StringTable());
  Lum::Label                 *label;
  Lum::Panel                 *panel;
  Lum::Object                *unitMode;
  Lum::Def::Boolean          prohibitScreenBlanking(Lum::Def::Desc(L"Prohibit screen blanking"),
                                                    ::prohibitScreenBlanking);
  Lum::Def::OneOfN           unitModeDef(Lum::Def::Desc(L"Unit mode"),
                                         ::unitMode);
                                         
  unitModeDef.AddChoice(Lum::Def::OneOfN::Choice(Lum::Def::Desc(L"m/km"),1));
  unitModeDef.AddChoice(Lum::Def::OneOfN::Choice(Lum::Def::Desc(L"ft/mi"),2));
                                        
  unitModeChoices->Append(L"m/km");
  unitModeChoices->Append(L"ft/mi");

  panel=Lum::HPanel::Create(true,false);

  label=Lum::Label::Create(true,false);

  unitMode=Lum::TableIndexValueButton::Create(L"Unit mode",
                                              ::unitMode,unitModeChoices,true);
  
  if (Lum::OS::Manager::repository->GetDisplayManager()==NULL) {
    ::prohibitScreenBlanking->Disable();
  }

  label->AddLabel(L"Prohibit screenblanking:",
                  Lum::OS::display->GetBehaviour()->GetBooleanControl(prohibitScreenBlanking,true,false));
  label->AddLabel(L"Unit mode:",unitMode);

  panel->Add(label);

  return panel;
}

void Settings::GetActions(std::vector<Lum::Dlg::ActionInfo>& actions)
{
  Lum::Dlg::ActionDialog::CreateActionInfosOkCancel(actions,okAction,GetClosedAction());
}

void Settings::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
{
  if (model==okAction && okAction->IsFinished()) {
    unitMode->Save();
  
    Exit();
  }

  ActionDialog::Resync(model,msg);
}

