/*
 *  GPSData for Maemo.
 *  Copyright (C) 2011 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <QtGui>

#include "satellitesignalstrengthwindow.h"

#ifdef Q_OS_SYMBIAN
SatelliteSignalStrengthWindow::SatelliteSignalStrengthWindow(QWidget *parent) : QMainWindow(parent)
{
    m_screenLocked = false;

    createUi();

    connect(parent, SIGNAL(screenLocked(bool)), this, SLOT(onScreenLocked(bool)));
}

void SatelliteSignalStrengthWindow::createUi()
{
    setAttribute(Qt::WA_DeleteOnClose);

    setWindowTitle(tr("Signal strength"));

    m_satelliteSignalStrength = new SatelliteSignalStrength();
    m_satelliteSignalStrength->showTitle(false);
    setCentralWidget(m_satelliteSignalStrength);

    QAction* backSoftkey = new QAction(tr("Back"), this);
    backSoftkey->setSoftKeyRole(QAction::NegativeSoftKey);
    connect(backSoftkey, SIGNAL(triggered()), this, SLOT(close()));
    addAction(backSoftkey);
}

void SatelliteSignalStrengthWindow::onScreenLocked(bool locked)
{
    m_screenLocked = locked;
}

void SatelliteSignalStrengthWindow::onSatellitesInViewUpdated(const QList<QGeoSatelliteInfo> &satellites)
{
    if (m_screenLocked)
        return;

    m_satelliteSignalStrength->updateWidget(satellites, false);
}

void SatelliteSignalStrengthWindow::onSatellitesInUseUpdated(const QList<QGeoSatelliteInfo> &satellites)
{
    if (m_screenLocked)
        return;

    m_satelliteSignalStrength->updateWidget(satellites, true);
}

void SatelliteSignalStrengthWindow::setSatelliteInfoSource(QGeoSatelliteInfoSource *satelliteInfoSource)
{
    m_satellite = satelliteInfoSource;
    if (m_satellite) {
        connect(m_satellite, SIGNAL(satellitesInViewUpdated(const QList<QGeoSatelliteInfo> &)), this,
                SLOT(onSatellitesInViewUpdated(const QList<QGeoSatelliteInfo> &)));
        connect(m_satellite, SIGNAL(satellitesInUseUpdated(const QList<QGeoSatelliteInfo> &)), this,
                SLOT(onSatellitesInUseUpdated(const QList<QGeoSatelliteInfo> &)));

        m_satellite->requestUpdate();
    }
}
#endif
