/*
 *  GPSData for Maemo.
 *  Copyright (C) 2011 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QWidget>
#include <QDialog>
#include <QLabel>

#include <QGeoPositionInfo>
#include <QGeoPositionInfoSource>
#include <QGeoSatelliteInfo>
#include <QGeoSatelliteInfoSource>

#ifdef Q_WS_MAEMO_5
# include "satellitesignalstrength.h"
#endif

QTM_USE_NAMESPACE

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    enum CoordinateType
    {
        LatitudeCoordinate = 0,
        LongitudeCoordinate = 1
    };

    MainWindow(QWidget *parent = 0);
    ~MainWindow();

signals:
    void screenLocked(bool locked);

private slots:
    void onPositionUpdated(const QGeoPositionInfo &position);

    void onSatellitesInViewUpdated(const QList<QGeoSatelliteInfo> &satellites);
    void onSatellitesInUseUpdated(const QList<QGeoSatelliteInfo> &satellites);

#ifdef Q_OS_SYMBIAN
    void onSatelliteSignalStrengthMenuClicked();
#endif
    void onSatelliteViewMenuClicked();
    void onGpsCompassMenuClicked();

#ifdef Q_WS_MAEMO_5
    void onScreenLocked(QString state);
#endif

private:
    void createUi();
    void updateUi();

    void createMenu();

#ifdef Q_WS_MAEMO_5
    void registerScreenLockMonitor();
#endif

    QString convertCoordinate(double speed, CoordinateType type) const;
    QString convertSpeed(double speed) const;
    QString formatLength(double length) const;
    QString formatDirection(double length) const;

private:
    QGeoPositionInfoSource *m_position;
    QGeoSatelliteInfoSource *m_satellite;

    QGeoPositionInfo m_positionInfo;
    int m_satellitesInView;
    int m_satellitesInUse;

    QLabel *m_latitude;
    QLabel *m_longitude;
    QLabel *m_accuracy;
    QLabel *m_altitude;
    QLabel *m_altitudeAccuracy;
    QLabel *m_direction;
    QLabel *m_magneticDeclination;
    QLabel *m_groundSpeed;
    QLabel *m_verticalSpeed;
    QLabel *m_mode;
    QLabel *m_time;
    QLabel *m_satUsedView;

#ifdef Q_WS_MAEMO_5
    SatelliteSignalStrength *m_satelliteSignalStrength;

    bool m_screenLocked;
#endif
};

#endif // MAINWINDOW_H
