/*
 *  GPSData for Maemo.
 *  Copyright (C) 2011 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef GPSCOMPASSWINDOW_H
#define GPSCOMPASSWINDOW_H

#include <QMainWindow>
#include <QWidget>

#include <QGeoPositionInfoSource>

#include "compass.h"

QTM_USE_NAMESPACE

class GpsCompassWindow : public QMainWindow
{
    Q_OBJECT

public:
    GpsCompassWindow(QWidget *parent = 0);
    ~GpsCompassWindow();

    void setPositionInfoSource(QGeoPositionInfoSource *positionInfoSource);

private slots:
    void onScreenLocked(bool locked);
    void onPositionUpdated(const QGeoPositionInfo &position);

private:
    void createUi();

private:
    bool m_screenLocked;

    QGeoPositionInfoSource *m_position;

    Compass *m_compass;
};

#endif // GPSCOMPASSWINDOW_H
