/*
 *  GPSData for Maemo.
 *  Copyright (C) 2011 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <QtGui>

#include "satelliteviewwindow.h"

SatelliteViewWindow::SatelliteViewWindow(QWidget *parent) : QMainWindow(parent)
{
    m_screenLocked = false;

    createUi();

    connect(parent, SIGNAL(screenLocked(bool)), this, SLOT(onScreenLocked(bool)));
}

void SatelliteViewWindow::createUi()
{
#if defined(Q_OS_SYMBIAN)
    setAttribute(Qt::WA_DeleteOnClose);
#elif defined(Q_WS_MAEMO_5)
    setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
    setWindowFlags(Qt::Dialog);
#endif

    setWindowTitle(tr("Satellite view"));

    m_satelliteView = new SatelliteView();
#ifdef Q_WS_MAEMO_5
    m_satelliteView->setMinimumSize(480, 480);
#endif
    setCentralWidget(m_satelliteView);

#ifdef Q_OS_SYMBIAN
    QAction* backSoftkey = new QAction(tr("Back"), this);
    backSoftkey->setSoftKeyRole(QAction::NegativeSoftKey);
    connect(backSoftkey, SIGNAL(triggered()), this, SLOT(close()));
    addAction(backSoftkey);
#endif
}

void SatelliteViewWindow::onScreenLocked(bool locked)
{
    m_screenLocked = locked;
}

void SatelliteViewWindow::onSatellitesInViewUpdated(const QList<QGeoSatelliteInfo> &satellites)
{
    if (m_screenLocked)
        return;

    m_satelliteView->updateWidget(satellites, false);
}

void SatelliteViewWindow::onSatellitesInUseUpdated(const QList<QGeoSatelliteInfo> &satellites)
{
    if (m_screenLocked)
        return;

    m_satelliteView->updateWidget(satellites, true);
}

void SatelliteViewWindow::setSatelliteInfoSource(QGeoSatelliteInfoSource *satelliteInfoSource)
{
    m_satellite = satelliteInfoSource;
    if (m_satellite) {
        connect(m_satellite, SIGNAL(satellitesInViewUpdated(const QList<QGeoSatelliteInfo> &)), this,
                SLOT(onSatellitesInViewUpdated(const QList<QGeoSatelliteInfo> &)));
        connect(m_satellite, SIGNAL(satellitesInUseUpdated(const QList<QGeoSatelliteInfo> &)), this,
                SLOT(onSatellitesInUseUpdated(const QList<QGeoSatelliteInfo> &)));

        m_satellite->requestUpdate();
    }
}
