/*
 *  GPSData for Maemo.
 *  Copyright (C) 2011 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SATELLITEVIEW_H
#define SATELLITEVIEW_H

#include <QWidget>

#include <QGeoSatelliteInfo>

QTM_USE_NAMESPACE

class SatelliteView : public QWidget
{
  Q_OBJECT

public:
    SatelliteView(QWidget *parent = 0);

    void updateWidget(const QList<QGeoSatelliteInfo> &satellites, bool inUseList);

private:
    static const int m_margin = 8;
    static const int m_numOfSatellites = 32;

    QColor m_graphGridColor;
    QColor m_satelliteBorderColor;
    QColor m_satelliteSolarPanelColor;
    QColor m_satellitehInViewColor;
    QColor m_satelliteInUseColor;

    QList<QGeoSatelliteInfo> m_satellitesInView;
    QList<QGeoSatelliteInfo> m_satellitesInUse;

    void paintLabels(QPainter &painter, const QRectF &area);
    void paintGrid(QPainter &painter, const QRectF &area);
    void paintSatellite(QPainter &painter, const QRectF &area, int index);

protected:
    void paintEvent(QPaintEvent *event);
};

#endif // SATELLITEVIEW_H
