/*
 *  GPSData for Maemo.
 *  Copyright (C) 2011 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef COMPASS_H
#define COMPASS_H

#ifdef QT_NO_OPENGL
#include <QWidget>
#else
#include <QGLWidget>
#endif
#include <QTimer>

#ifdef QT_NO_OPENGL
class Compass : public QWidget
#else
class Compass : public QGLWidget
#endif
{
  Q_OBJECT

public:
    enum CompassType
    {
        Gps = 0,
        Sensor = 1
    };

    Compass(CompassType type);
    ~Compass();

    void updateWidget(const int azimuth, double calibration);
    void updateWidget(const int azimuth, bool locked, int speed);

private slots:
    void moveTimerEvent();

private:
    CompassType m_type;
    int m_azimuth;
    int m_compassAzimuth;
    bool m_locked;
    int m_gpsSpeed;
    double m_sensorCalibLevel;

    QColor m_azimuthLabelWarnColor;
    QColor m_scaleColor;
    QColor m_windroseNorthColor;
    QColor m_windroseColor;
    QColor m_windroseBckColor;

    void paintAzimuth(QPainter &painter, const QRectF &area);
    void paintCompass(QPainter &painter, const QRectF &area);

    QTimer *m_rotateTimer;

protected:
    void paintEvent(QPaintEvent *event);
};

#endif // GCOMPASS_H
