/* gui.c
 * Written by Daniel Foote.
 * Started Feb 2005.
 *
 * The base of this file was generated with Glade, and then
 * hand edited by me for some strange reason.
 *
 * This file contains the code to create, generate, and look after
 * a GTK GUI for the photo correlation program. 
 *
 * Modified for maemo 5 by Julius Luukko in May 2010.
 *
 */

/* This is "basically" the GUI version of it. The only other
 * part of the gui program is main-gui.c, but that ended up
 * being little more than a "stub" to get the GUI up and running. */

/* Copyright 2005 Daniel Foote.
 *
 * This file is part of gpscorrelate.
 *
 * gpscorrelate is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gpscorrelate is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gpscorrelate; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

/****************************************************
 * maemo 5 related start
 ***************************************************/
#include <hildon/hildon.h>
#include <hildon/hildon-program.h>
#include <hildon-fm-2/hildon/hildon-file-chooser-dialog.h>
#include <hildon-fm-2/hildon/hildon-file-system-model.h>
#include <hildon-fm-2/hildon/hildon-file-selection.h>
/* #include <libosso.h> */
/****************************************************
 * maemo 5 related end
 ***************************************************/

#include "gpsstructure.h"
#include "gui.h"
#include "exif-gps.h"
#include "gpx-read.h"
#include "correlate.h"

/* Declare all our widgets. Global to this module. */
GtkWidget *MatchWindow;
GtkWidget *WindowHBox;
GtkWidget *ControlsVBox;

GtkWidget *AddPhotosFrame;
GtkWidget *AddPhotosAlignment;
GtkWidget *AddPhotosVBox;
GtkWidget *PhotoAddButton;
GtkWidget *PhotoRemoveButton;
GtkWidget *AddPhotosLabel;

GtkWidget *GPSDataFrame;
GtkWidget *GPSDataAlignment;
GtkWidget *GPSDataVBox;
GtkWidget *GPSSelectedLabel;
GtkWidget *SelectGPSButton;
GtkWidget *GPSDataLabel;

GtkWidget *OptionsFrame;
GtkWidget *OptionsAlignment;
GtkWidget *OptionsVBox;
GtkWidget *InterpolateCheck;
GtkWidget *NoWriteCheck;
GtkWidget *NoMtimeCheck;
GtkWidget *BetweenSegmentsCheck;
GtkWidget *DegMinSecsCheck;
GtkWidget *OptionsTable;
GtkWidget *MaxGapTimeLabel;
GtkWidget *TimeZoneLabel;
GtkWidget *PhotoOffsetLabel;
GtkWidget *GPSDatumLabel;
GtkWidget *GapTimeEntry;
GtkWidget *TimeZoneEntry;
GtkWidget *PhotoOffsetEntry;
GtkWidget *GPSDatumEntry;
GtkWidget *OptionsFrameLable;

GtkWidget *CorrelateFrame;
GtkWidget *CorrelateAlignment;
GtkWidget *CorrelateButton;
GtkWidget *CorrelateLabel;

GtkWidget *OtherOptionsFrame;
GtkWidget *OtherOptionsAlignment;
GtkWidget *OtherOptionsLabel;
GtkWidget *StripGPSButton;

GtkWidget *PhotoListVBox;
GtkWidget *PhotoListScroll;
GtkWidget *PhotoList;
GtkTooltips *tooltips;

/****************************************************
 * maemo 5 related start
 ***************************************************/
#if MAEMO_VERSION_MAJOR == 5
/* osso_context_t *osso;       /\* handle to osso *\/ */
HildonProgram *program;     /* handle to application */
HildonAppMenu *main_menu;   /* main menu */
GtkWidget *mm_add_file;     /* main menu item */
GtkWidget *mm_del_file;     /* main menu item */
GtkWidget *mm_sel_gpx;      /* main menu item */
GtkWidget *mm_options;      /* main menu item */
GtkWidget *mm_strip_gps;      /* main menu item */
GtkWidget *mm_correlate;      /* main menu item */
GtkWidget *mm_about;      /* main menu item */
GtkWidget *options_interpolate_check;
GtkWidget *options_dontwrite_check;
GtkWidget *options_nomtime_check;
GtkWidget *options_betweensegments_check;
GtkWidget *options_degminsecs_check;
GtkWidget *options_options_table;
GtkWidget *options_maxgaptime_label;
GtkWidget *options_maxgaptime_entry;
GtkWidget *options_timezone_label;
GtkWidget *options_timezone_entry;
GtkWidget *options_photooffset_label;
GtkWidget *options_photooffset_entry;
GtkWidget *options_gpsdatum_label;
GtkWidget *options_gpsdatum_entry;
GtkWidget *toolbar;
GtkToolItem *toolbar_add;
GtkToolItem *toolbar_delete;
GtkToolItem *toolbar_settings;
GtkToolItem *toolbar_correlate;

#define DIALOG_MIN_HEIGHTMAX 400
#define RESPONSE_SELECT_ALL 1
#endif

/****************************************************
 * maemo 5 related end
 ***************************************************/

/* Enum and other stuff for the Photo list box. */
enum
{
	LIST_FILENAME,
	LIST_STATE,
	LIST_LAT,
	LIST_LONG,
	LIST_ELEV,
	LIST_TIME,
	LIST_POINTER,
	LIST_NOCOLUMNS
};

GtkListStore *PhotoListStore;
GtkCellRenderer *PhotoListRenderer;
GtkTreeViewColumn *FileColumn;
GtkTreeViewColumn *LatColumn;
GtkTreeViewColumn *LongColumn;
GtkTreeViewColumn *ElevColumn;
GtkTreeViewColumn *TimeColumn;
GtkTreeViewColumn *StateColumn;

/* Structure and variables for holding the list of
 * photos in memory. */

struct GUIPhotoList {
	char* Filename;
	char* Time;
	GtkTreeIter ListPointer;
	struct GUIPhotoList* Next;
};

struct GUIPhotoList* FirstPhoto = NULL;
struct GUIPhotoList* LastPhoto = NULL;

struct GPSPoint* GPSData = NULL;

char* ConfigDefaults[] = {
	"interpolate", "true",
	"dontwrite", "false",
	"nochangemtime", "false",
	"betweensegments", "false",
	"writeddmmss", "true",
	"maxgap", "0",
	"timezone", "+0:00",
	"photooffset", "0",
	"gpsdatum", "WGS-84",
	"gpxopendir", "",
	"photoopendir", "",
	NULL, NULL
};

GKeyFile* GUISettings;
char* SettingsFilename;
gchar* GPXOpenDir = NULL;
gchar* PhotoOpenDir = NULL;

/* /\**************************************************** */
/*  * maemo 5 related start */
/*  ***************************************************\/ */
/* gint dbus_callback (const gchar *interface, const gchar *method, */
/* 		    GArray *arguments, gpointer data, */
/* 		    osso_rpc_t *retval) */
/* { */
/*   if (!strcmp (method, "top_application")) */
/*       gtk_window_present (GTK_WINDOW (data)); */

/*   retval->type = DBUS_TYPE_INVALID; */
/*   return OSSO_OK; */
/* } */
/* /\**************************************************** */
/*  * maemo 5 related end */
/*  ***************************************************\/ */

void CallbackAbout( GtkAction * action, gpointer data )
{
  GtkWidget *dialog;

  dialog = gtk_about_dialog_new ();
  gtk_about_dialog_set_name(GTK_ABOUT_DIALOG(dialog), "GPSCorrelate");
  gtk_about_dialog_set_version(GTK_ABOUT_DIALOG(dialog), "1.6.1"); 
  gtk_about_dialog_set_copyright(GTK_ABOUT_DIALOG(dialog), 
				 "(C) 2005-2010 Daniel Foote. Maemo version by Julius Luukko 2010");

  gtk_about_dialog_set_license(GTK_ABOUT_DIALOG(dialog),
			       "Licensed under GNU GPL v. 2");
  gtk_about_dialog_set_website(GTK_ABOUT_DIALOG(dialog),
			       "http://freefoote.dview.net/linux_gpscorr.html");
  gtk_dialog_run(GTK_DIALOG (dialog));
  gtk_widget_destroy(dialog);
}


/* Load settings, insert defaults. */
void LoadSettings()
{
	/* Generate the filename. */
	const char* UserHomeDir = g_get_user_config_dir();
	int FilenameLength = strlen(UserHomeDir) + 30;
	SettingsFilename = malloc(sizeof(char) * FilenameLength);

	snprintf(SettingsFilename, FilenameLength, "%s%c.gpscorrelaterc", UserHomeDir, G_DIR_SEPARATOR);

	/* Create a new key file. */
	GUISettings = g_key_file_new();

	if (!g_key_file_load_from_file(GUISettings, SettingsFilename, G_KEY_FILE_KEEP_COMMENTS, NULL))
	{
		/* Unable to load the file. Oh well. */
	}

	/* Now create all the default settings. */
	int i = 0;
	while (ConfigDefaults[i])
	{
		/* If the setting doesn't exist, set the default. */
		if (NULL == g_key_file_get_value(GUISettings, "default", ConfigDefaults[i], NULL))
		{
			g_key_file_set_value(GUISettings, "default", ConfigDefaults[i], ConfigDefaults[i+1]);
		}

		i += 2;
	}
}

void SaveSettings()
{
	/* Save the settings to file, and deallocate the settings. */
	FILE* OutputFile;

	OutputFile = fopen(SettingsFilename, "w");

	gsize SettingsLength = 0;
	gchar* SettingsString = g_key_file_to_data(GUISettings, &SettingsLength, NULL);

	fwrite((void*)SettingsString, sizeof(gchar), (size_t)SettingsLength, OutputFile);

	fclose(OutputFile);

	g_free(SettingsString);
	free(SettingsFilename);
}


GtkWidget* CreateMatchWindow (void)
{
/****************************************************
 * maemo 5 related start
 ***************************************************/
#if MAEMO_VERSION_MAJOR == 5
  GtkTreeSelection    *select;
/*   osso_return_t ret; */

/*   osso = osso_initialize ("org.luukko.gpscorrelate-gui", "1.6.1-1maemo1", TRUE, NULL); */
/*   if (osso == NULL) { */
/*     fprintf (stderr, "osso_initialize failed.\n"); */
/*     exit (1); */
/*   } */

/*   ret = osso_rpc_set_default_cb_f (osso, dbus_callback, NULL); */
/*   if (ret != OSSO_OK) */
/*     { */
/*       fprintf (stderr, "osso_rpc_set_default_cb_f failed: %d.\n", ret); */
/*       exit (1); */
/*     } */
/****************************************************
 * maemo 5 related end
 ***************************************************/
#endif

  /* Load the settings. */
  LoadSettings();

  /* Get our tooltips ready. */
  tooltips = gtk_tooltips_new ();

  /* Start with the window itself. */
#if MAEMO_VERSION_MAJOR == 5
  program = HILDON_PROGRAM(hildon_program_get_instance());
  g_set_application_name("GPS Photo Correlate");

  MatchWindow = hildon_stackable_window_new();
  hildon_program_add_window(program, HILDON_WINDOW(MatchWindow));
#else
  MatchWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (MatchWindow), "GPS Photo Correlate");
  gtk_window_set_default_size (GTK_WINDOW (MatchWindow), 700, -1);
#endif

  g_signal_connect (G_OBJECT (MatchWindow), "delete_event",
  		G_CALLBACK (DestroyWindow), NULL);

  /* Menu for maemo 5 */
#if MAEMO_VERSION_MAJOR == 5
  main_menu = HILDON_APP_MENU (hildon_app_menu_new ());

  mm_add_file = hildon_button_new_with_text(HILDON_SIZE_AUTO,
					    HILDON_BUTTON_ARRANGEMENT_VERTICAL,
					    "Add photo files",
					    NULL);
  hildon_app_menu_append (main_menu, GTK_BUTTON (mm_add_file));
  g_signal_connect(G_OBJECT(mm_add_file), "clicked",
		   G_CALLBACK(AddPhotosButtonPress), NULL);


  mm_del_file = hildon_button_new_with_text(HILDON_SIZE_AUTO,
					    HILDON_BUTTON_ARRANGEMENT_VERTICAL,
					    "Remove a photo file",
					    NULL);
  hildon_app_menu_append (main_menu, GTK_BUTTON (mm_del_file));
  g_signal_connect(G_OBJECT(mm_del_file), "clicked",
		   G_CALLBACK(RemovePhotosButtonPress), NULL);

  mm_sel_gpx = hildon_button_new_with_text(HILDON_SIZE_AUTO,
					    HILDON_BUTTON_ARRANGEMENT_VERTICAL,
					    "Choose a GPX file",
					    "(not chosen)");
  hildon_app_menu_append (main_menu, GTK_BUTTON (mm_sel_gpx));
  g_signal_connect(G_OBJECT(mm_sel_gpx), "clicked",
		   G_CALLBACK(SelectGPSButtonPress), NULL);

  mm_options = hildon_button_new_with_text(HILDON_SIZE_AUTO,
					    HILDON_BUTTON_ARRANGEMENT_VERTICAL,
					    "Options",
					    NULL);
  hildon_app_menu_append (main_menu, GTK_BUTTON (mm_options));
  g_signal_connect(G_OBJECT(mm_options), "clicked",
		   G_CALLBACK(SelectOptionsButtonPress), NULL);

  mm_strip_gps = hildon_button_new_with_text(HILDON_SIZE_AUTO,
					    HILDON_BUTTON_ARRANGEMENT_VERTICAL,
					    "Strip GPS tags",
					    NULL);
  hildon_app_menu_append (main_menu, GTK_BUTTON (mm_strip_gps));
  g_signal_connect(G_OBJECT(mm_strip_gps), "clicked",
		   G_CALLBACK(StripGPSButtonPress), NULL);

  mm_correlate = hildon_button_new_with_text(HILDON_SIZE_AUTO,
					    HILDON_BUTTON_ARRANGEMENT_VERTICAL,
					    "Correlate",
					    NULL);
  hildon_app_menu_append (main_menu, GTK_BUTTON (mm_correlate));
  g_signal_connect(G_OBJECT(mm_correlate), "clicked",
		   G_CALLBACK(CorrelateButtonPress), NULL);

  mm_about = hildon_button_new_with_text(HILDON_SIZE_AUTO,
					    HILDON_BUTTON_ARRANGEMENT_VERTICAL,
					    "About",
					    NULL);
  hildon_app_menu_append (main_menu, GTK_BUTTON (mm_about));
  g_signal_connect(G_OBJECT(mm_about), "clicked",
		   G_CALLBACK(CallbackAbout), NULL);

  hildon_window_set_app_menu(HILDON_WINDOW(MatchWindow), main_menu);
  gtk_widget_show_all(GTK_WIDGET(main_menu));
#endif

  WindowHBox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (WindowHBox);
  gtk_container_add (GTK_CONTAINER (MatchWindow), WindowHBox);

#ifndef MAEMO_VERSION_MAJOR
  /* The controls side of the window. */
  ControlsVBox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (ControlsVBox);
  gtk_box_pack_start (GTK_BOX (WindowHBox), ControlsVBox, FALSE, TRUE, 0);

  /* Add/remove photos area. */
  AddPhotosFrame = gtk_frame_new (NULL);
  gtk_widget_show (AddPhotosFrame);
  gtk_box_pack_start (GTK_BOX (ControlsVBox), AddPhotosFrame, FALSE, FALSE, 0);

  AddPhotosAlignment = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (AddPhotosAlignment);
  gtk_container_add (GTK_CONTAINER (AddPhotosFrame), AddPhotosAlignment);
  gtk_alignment_set_padding (GTK_ALIGNMENT (AddPhotosAlignment), 0, 4, 12, 4);

  AddPhotosVBox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (AddPhotosVBox);
  gtk_container_add (GTK_CONTAINER (AddPhotosAlignment), AddPhotosVBox);

  PhotoAddButton = gtk_button_new_with_mnemonic ("Add...");
  gtk_widget_show (PhotoAddButton);
  gtk_box_pack_start (GTK_BOX (AddPhotosVBox), PhotoAddButton, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, PhotoAddButton, "Add photos to be correlated.", NULL);
  g_signal_connect (G_OBJECT (PhotoAddButton), "clicked",
  		G_CALLBACK (AddPhotosButtonPress), NULL);

  PhotoRemoveButton = gtk_button_new_with_mnemonic ("Remove");
  gtk_widget_show (PhotoRemoveButton);
  gtk_box_pack_start (GTK_BOX (AddPhotosVBox), PhotoRemoveButton, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, PhotoRemoveButton, "Remove selected photos from the list.", NULL);
  g_signal_connect (G_OBJECT (PhotoRemoveButton), "clicked",
  		G_CALLBACK (RemovePhotosButtonPress), NULL);

  AddPhotosLabel = gtk_label_new ("<b>1. Add Photos</b>");
  gtk_widget_show (AddPhotosLabel);
  gtk_frame_set_label_widget (GTK_FRAME (AddPhotosFrame), AddPhotosLabel);
  gtk_label_set_use_markup (GTK_LABEL (AddPhotosLabel), TRUE);

  /* GPS data area */
  GPSDataFrame = gtk_frame_new (NULL);
  gtk_widget_show (GPSDataFrame);
  gtk_box_pack_start (GTK_BOX (ControlsVBox), GPSDataFrame, FALSE, FALSE, 0);

  GPSDataAlignment = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (GPSDataAlignment);
  gtk_container_add (GTK_CONTAINER (GPSDataFrame), GPSDataAlignment);
  gtk_alignment_set_padding (GTK_ALIGNMENT (GPSDataAlignment), 0, 4, 12, 4);

  GPSDataVBox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (GPSDataVBox);
  gtk_container_add (GTK_CONTAINER (GPSDataAlignment), GPSDataVBox);

  GPSSelectedLabel = gtk_label_new ("Reading From: No file");  /* FIX ME: Label not appropriately sized/placed for data. */
  gtk_widget_show (GPSSelectedLabel);
  gtk_box_pack_start (GTK_BOX (GPSDataVBox), GPSSelectedLabel, FALSE, FALSE, 0);
  gtk_label_set_ellipsize(GTK_LABEL(GPSSelectedLabel), PANGO_ELLIPSIZE_END); 
  /*gtk_label_set_width_chars(GTK_LABEL(GPSSelectedLabel), 20);
  gtk_label_set_line_wrap(GTK_LABEL(GPSSelectedLabel), TRUE);*/

  SelectGPSButton = gtk_button_new_with_mnemonic ("Choose...");
  gtk_widget_show (SelectGPSButton);
  gtk_box_pack_start (GTK_BOX (GPSDataVBox), SelectGPSButton, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, SelectGPSButton, "Choose GPX file to read GPS data from. If the GPS data is not in the GPX format, use a convertor like GPSBabel to convert it to GPX.", NULL);
  g_signal_connect (G_OBJECT (SelectGPSButton), "clicked",
  		G_CALLBACK (SelectGPSButtonPress), NULL);

  GPSDataLabel = gtk_label_new ("<b>2. GPS Data</b>");
  gtk_widget_show (GPSDataLabel);
  gtk_frame_set_label_widget (GTK_FRAME (GPSDataFrame), GPSDataLabel);
  gtk_label_set_use_markup (GTK_LABEL (GPSDataLabel), TRUE);

  /* Options area. */
  OptionsFrame = gtk_frame_new (NULL);
  gtk_widget_show (OptionsFrame);
  gtk_box_pack_start (GTK_BOX (ControlsVBox), OptionsFrame, FALSE, FALSE, 0);

  OptionsAlignment = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (OptionsAlignment);
  gtk_container_add (GTK_CONTAINER (OptionsFrame), OptionsAlignment);
  gtk_alignment_set_padding (GTK_ALIGNMENT (OptionsAlignment), 0, 4, 12, 4);

  OptionsVBox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (OptionsVBox);
  gtk_container_add (GTK_CONTAINER (OptionsAlignment), OptionsVBox);

  InterpolateCheck = gtk_check_button_new_with_mnemonic ("Interpolate");
  gtk_widget_show (InterpolateCheck);
  gtk_box_pack_start (GTK_BOX (OptionsVBox), InterpolateCheck, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, InterpolateCheck, "Interpolate between points. If disabled, points will be rounded to the nearest recorded point.", NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (InterpolateCheck), g_key_file_get_boolean(GUISettings, "default", "interpolate", NULL));

  NoWriteCheck = gtk_check_button_new_with_mnemonic ("Don't write");
  gtk_widget_show (NoWriteCheck);
  gtk_box_pack_start (GTK_BOX (OptionsVBox), NoWriteCheck, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, NoWriteCheck, "Don't write EXIF data back to the photos.", NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (NoWriteCheck), g_key_file_get_boolean(GUISettings, "default", "dontwrite", NULL));

  NoMtimeCheck = gtk_check_button_new_with_mnemonic ("Don't change mtime");
  gtk_widget_show (NoMtimeCheck);
  gtk_box_pack_start (GTK_BOX (OptionsVBox), NoMtimeCheck, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, NoMtimeCheck, "Don't change file modification time of the photos.", NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (NoMtimeCheck), g_key_file_get_boolean(GUISettings, "default", "nochangemtime", NULL));

  BetweenSegmentsCheck = gtk_check_button_new_with_mnemonic ("Between Segments");
  gtk_widget_show (BetweenSegmentsCheck);
  gtk_box_pack_start (GTK_BOX (OptionsVBox), BetweenSegmentsCheck, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, BetweenSegmentsCheck, "Interpolate between track segments. Generally the data is segmented to show where data was available and not available, but you might still want to interpolate between segments.", NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (BetweenSegmentsCheck), g_key_file_get_boolean(GUISettings, "default", "betweensegments", NULL));

  DegMinSecsCheck = gtk_check_button_new_with_mnemonic ("Write DD MM SS.SS");
  gtk_widget_show (DegMinSecsCheck);
  gtk_box_pack_start (GTK_BOX (OptionsVBox), DegMinSecsCheck, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, DegMinSecsCheck, "Write the lattitude and longitude values as DD MM SS.SS. This is the new default as of v1.5.3. The old behaviour is to write it as DD MM.MM, which will occur if you uncheck this box.", NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (DegMinSecsCheck), g_key_file_get_boolean(GUISettings, "default", "writeddmmss", NULL));

  OptionsTable = gtk_table_new (4, 2, FALSE);
  gtk_widget_show (OptionsTable);
  gtk_box_pack_start (GTK_BOX (OptionsVBox), OptionsTable, TRUE, TRUE, 0);

  MaxGapTimeLabel = gtk_label_new ("Max gap time:");
  gtk_widget_show (MaxGapTimeLabel);
  gtk_table_attach (GTK_TABLE (OptionsTable), MaxGapTimeLabel, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (MaxGapTimeLabel), 0, 0.5);

  TimeZoneLabel = gtk_label_new ("Time Zone:");
  gtk_widget_show (TimeZoneLabel);
  gtk_table_attach (GTK_TABLE (OptionsTable), TimeZoneLabel, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (TimeZoneLabel), 0, 0.5);
  
  PhotoOffsetLabel = gtk_label_new ("Photo Offset:");
  gtk_widget_show (PhotoOffsetLabel);
  gtk_table_attach (GTK_TABLE (OptionsTable), PhotoOffsetLabel, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PhotoOffsetLabel), 0, 0.5);

  GPSDatumLabel = gtk_label_new ("GPS Datum:");
  gtk_widget_show (GPSDatumLabel);
  gtk_table_attach (GTK_TABLE (OptionsTable), GPSDatumLabel, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (GPSDatumLabel), 0, 0.5);

  GapTimeEntry = gtk_entry_new ();
  gtk_widget_show (GapTimeEntry);
  gtk_table_attach (GTK_TABLE (OptionsTable), GapTimeEntry, 1, 2, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, GapTimeEntry, "Maximum time \"away\" from a point that the photo will be matched, in seconds. If a photos time is outside this value from any point, it will not be matched.", NULL);
  gtk_entry_set_text (GTK_ENTRY (GapTimeEntry), g_key_file_get_value(GUISettings, "default", "maxgap", NULL));
  gtk_entry_set_width_chars (GTK_ENTRY (GapTimeEntry), 7);

  TimeZoneEntry = gtk_entry_new ();
  gtk_widget_show (TimeZoneEntry);
  gtk_table_attach (GTK_TABLE (OptionsTable), TimeZoneEntry, 1, 2, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, TimeZoneEntry, "The timezone that the cameras time was set to when the photos were taken. For example, if a camera is set to AWST or +8:00 hours. Enter +8:00 here so that the correct adjustment to the photos time can be made. GPS data is always in UTC.", NULL);
  gtk_entry_set_text (GTK_ENTRY (TimeZoneEntry), g_key_file_get_value(GUISettings, "default", "timezone", NULL));
  gtk_entry_set_width_chars (GTK_ENTRY (TimeZoneEntry), 7);
  
  PhotoOffsetEntry = gtk_entry_new ();
  gtk_widget_show (PhotoOffsetEntry);
  gtk_table_attach (GTK_TABLE (OptionsTable), PhotoOffsetEntry, 1, 2, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, PhotoOffsetEntry, "The number of seconds to ADD to the photos time to make it match the GPS data. Calculate this with (GPS - Photo). Can be negative or positive.", NULL);
  gtk_entry_set_text (GTK_ENTRY (PhotoOffsetEntry), g_key_file_get_value(GUISettings, "default", "photooffset", NULL));
  gtk_entry_set_width_chars (GTK_ENTRY (PhotoOffsetEntry), 7);

  GPSDatumEntry = gtk_entry_new ();
  gtk_widget_show (GPSDatumEntry);
  gtk_table_attach (GTK_TABLE (OptionsTable), GPSDatumEntry, 1, 2, 4, 5,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_tooltips_set_tip (tooltips, GPSDatumEntry, "The datum used for the GPS data. This text here is recorded in the EXIF tags as the source datum. WGS-84 is very commonly used.", NULL);
  gtk_entry_set_text (GTK_ENTRY (GPSDatumEntry), g_key_file_get_value(GUISettings, "default", "gpsdatum", NULL));
  gtk_entry_set_width_chars (GTK_ENTRY (GPSDatumEntry), 7);

  OptionsFrameLable = gtk_label_new ("<b>3. Set options</b>");
  gtk_widget_show (OptionsFrameLable);
  gtk_frame_set_label_widget (GTK_FRAME (OptionsFrame), OptionsFrameLable);
  gtk_label_set_use_markup (GTK_LABEL (OptionsFrameLable), TRUE);

  /* Correlate button area. */
  CorrelateFrame = gtk_frame_new (NULL);
  gtk_widget_show (CorrelateFrame);
  gtk_box_pack_start (GTK_BOX (ControlsVBox), CorrelateFrame, FALSE, FALSE, 0);

  CorrelateAlignment = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (CorrelateAlignment);
  gtk_container_add (GTK_CONTAINER (CorrelateFrame), CorrelateAlignment);
  gtk_alignment_set_padding (GTK_ALIGNMENT (CorrelateAlignment), 0, 4, 12, 4);

  CorrelateButton = gtk_button_new_with_mnemonic ("Correlate Photos");
  gtk_widget_show (CorrelateButton);
  gtk_container_add (GTK_CONTAINER (CorrelateAlignment), CorrelateButton);
  gtk_tooltips_set_tip (tooltips, CorrelateButton, "Begin the correlation process, writing back to the photos if not disabled.", NULL);
  g_signal_connect (G_OBJECT (CorrelateButton), "clicked",
  		G_CALLBACK (CorrelateButtonPress), NULL);

  CorrelateLabel = gtk_label_new ("<b>4. Correlate!</b>");
  gtk_widget_show (CorrelateLabel);
  gtk_frame_set_label_widget (GTK_FRAME (CorrelateFrame), CorrelateLabel);
  gtk_label_set_use_markup (GTK_LABEL (CorrelateLabel), TRUE);
  
  /* Other options area. */
  OtherOptionsFrame = gtk_frame_new (NULL);
  gtk_widget_show (OtherOptionsFrame);
  gtk_box_pack_start (GTK_BOX (ControlsVBox), OtherOptionsFrame, FALSE, FALSE, 0);

  OtherOptionsAlignment = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (OtherOptionsAlignment);
  gtk_container_add (GTK_CONTAINER (OtherOptionsFrame), OtherOptionsAlignment);
  gtk_alignment_set_padding (GTK_ALIGNMENT (OtherOptionsAlignment), 0, 4, 12, 4);

  StripGPSButton = gtk_button_new_with_mnemonic ("Strip GPS tags");
  gtk_widget_show (StripGPSButton);
  gtk_container_add (GTK_CONTAINER (OtherOptionsAlignment), StripGPSButton);
  gtk_tooltips_set_tip (tooltips, StripGPSButton, "Strip GPS tags from the selected photos.", NULL);
  g_signal_connect (G_OBJECT (StripGPSButton), "clicked",
  		G_CALLBACK (StripGPSButtonPress), NULL);

  OtherOptionsLabel = gtk_label_new ("<b>Other Tools</b>");
  gtk_widget_show (OtherOptionsLabel);
  gtk_frame_set_label_widget (GTK_FRAME (OtherOptionsFrame), OtherOptionsLabel);
  gtk_label_set_use_markup (GTK_LABEL (OtherOptionsLabel), TRUE);
#endif

  /* Photo list box area of the window. */
  PhotoListVBox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (PhotoListVBox);
  gtk_box_pack_start (GTK_BOX (WindowHBox), PhotoListVBox, TRUE, TRUE, 0);

#if MAEMO_VERSION_MAJOR == 5
  PhotoListScroll = hildon_pannable_area_new();
  g_object_set(G_OBJECT(PhotoListScroll), "mov-mode", HILDON_MOVEMENT_MODE_BOTH, NULL);
#else
  PhotoListScroll = gtk_scrolled_window_new (NULL, NULL);
#endif
  gtk_widget_show (PhotoListScroll);
  gtk_box_pack_start (GTK_BOX (PhotoListVBox), PhotoListScroll, TRUE, TRUE, 0);
#ifndef MAEMO_VERSION_MAJOR
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (PhotoListScroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (PhotoListScroll), GTK_SHADOW_IN);
#endif

  /* Get the photo list store ready. */
  PhotoListStore = gtk_list_store_new(LIST_NOCOLUMNS,
		  G_TYPE_STRING,  /* The Filename */
		  G_TYPE_STRING,  /* Latitude     */
		  G_TYPE_STRING,  /* Longitude    */
		  G_TYPE_STRING,  /* Elevation    */
		  G_TYPE_STRING,  /* The Time     */
		  G_TYPE_STRING,  /* The State    */
		  G_TYPE_POINTER); /* Pointer to the matching list item. */

#if MAEMO_VERSION_MAJOR == 5
  PhotoList = hildon_gtk_tree_view_new_with_model (HILDON_UI_MODE_EDIT, 
					      GTK_TREE_MODEL(PhotoListStore));
#else
  PhotoList = gtk_tree_view_new_with_model (GTK_TREE_MODEL(PhotoListStore));
#endif
  gtk_widget_show (PhotoList);
  gtk_container_add (GTK_CONTAINER (PhotoListScroll), PhotoList);

  gtk_tree_selection_set_mode(gtk_tree_view_get_selection(GTK_TREE_VIEW(PhotoList)), GTK_SELECTION_MULTIPLE);
  
  /* Prepare the columns. We need columns. Columns are good. */
  PhotoListRenderer = gtk_cell_renderer_text_new ();

  /* File Column. */
  FileColumn = gtk_tree_view_column_new_with_attributes ("File", PhotoListRenderer,
							"text", LIST_FILENAME,
							NULL);
  gtk_tree_view_column_set_resizable (FileColumn, TRUE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (PhotoList), FileColumn);

  /* State column. */
  StateColumn = gtk_tree_view_column_new_with_attributes ("State", PhotoListRenderer,
							"text", LIST_STATE,
							NULL);
  gtk_tree_view_column_set_resizable (StateColumn, TRUE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (PhotoList), StateColumn);

  /* Lattitude Column. */
  LatColumn = gtk_tree_view_column_new_with_attributes ("Latitude", PhotoListRenderer,
							"text", LIST_LAT,
							NULL);
  gtk_tree_view_column_set_resizable (LatColumn, TRUE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (PhotoList), LatColumn);
  
  /* Longitude Column. */
  LongColumn = gtk_tree_view_column_new_with_attributes ("Longitude", PhotoListRenderer,
							"text", LIST_LONG,
							NULL);
  gtk_tree_view_column_set_resizable (LongColumn, TRUE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (PhotoList), LongColumn);
  
  /* Elevation Column. */
  ElevColumn = gtk_tree_view_column_new_with_attributes ("Elevation", PhotoListRenderer,
							"text", LIST_ELEV,
							NULL);
  gtk_tree_view_column_set_resizable (ElevColumn, TRUE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (PhotoList), ElevColumn);
  
  /* Time column. */
  TimeColumn = gtk_tree_view_column_new_with_attributes ("Time", PhotoListRenderer,
							"text", LIST_TIME,
							NULL);
  gtk_tree_view_column_set_resizable (TimeColumn, TRUE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (PhotoList), TimeColumn);

#if MAEMO_VERSION_MAJOR == 5
  CreateToolbar(MatchWindow);

  /* On maemo the default is not to show headers */
  gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(PhotoList), TRUE);

  /* With hildon_pannable_area this has to be done explicitely */
  select = gtk_tree_view_get_selection (GTK_TREE_VIEW (PhotoList));
  gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
#endif

  /* Final thing: show the window. */
  gtk_widget_show(MatchWindow);

  /* Done! Return a pointer to the window, although we never use it... */
  return MatchWindow;
}

gboolean DestroyWindow(GtkWidget *Widget,
		GdkEvent *Event,
		gpointer Data)
{
	/* Record the settings, and then save them. */
#if 0
	g_key_file_set_boolean(GUISettings, "default", "interpolate", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(InterpolateCheck)));
	g_key_file_set_boolean(GUISettings, "default", "dontwrite", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(NoWriteCheck)));
	g_key_file_set_boolean(GUISettings, "default", "nochangemtime", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(NoMtimeCheck)));
	g_key_file_set_boolean(GUISettings, "default", "betweensegments", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(BetweenSegmentsCheck)));
	g_key_file_set_boolean(GUISettings, "default", "writeddmmss", gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(DegMinSecsCheck)));
	g_key_file_set_string(GUISettings, "default", "maxgap", gtk_entry_get_text(GTK_ENTRY(GapTimeEntry)));
	g_key_file_set_string(GUISettings, "default", "timezone", gtk_entry_get_text(GTK_ENTRY(TimeZoneEntry)));
	g_key_file_set_string(GUISettings, "default", "photooffset", gtk_entry_get_text(GTK_ENTRY(PhotoOffsetEntry)));
	g_key_file_set_string(GUISettings, "default", "gpsdatum", gtk_entry_get_text(GTK_ENTRY(GPSDatumEntry)));
#endif
	g_key_file_set_string(GUISettings, "default", "gpxopendir", GPXOpenDir);
	g_key_file_set_string(GUISettings, "default", "photoopendir", PhotoOpenDir);
	SaveSettings();

	/* Someone closed the window. */
	/* Free the memory we allocated for the photo list. */
	struct GUIPhotoList* Free = NULL;
	struct GUIPhotoList* Free2 = NULL;
	if (FirstPhoto)
	{
		/* Walk through the singly-linked list
		 * freeing stuff. */
		Free = FirstPhoto;
		while (1)
		{
			if (Free->Filename) free(Free->Filename);
			if (Free->Time)     free(Free->Time);
			Free2 = Free->Next;
			free(Free);
			if (Free2 == NULL) break;
			Free = Free2;
		}
	}
	
	/* Free the memory for the GPS data, if applicable. */
	if (GPSData) FreePointList(GPSData);

	/* Tell GTK that we're done. */
	gtk_exit(0);

/* 	osso_deinitialize(osso); */

	/* And return FALSE so that GTK knows we have not
	 * vetoed the close. */
	return FALSE;
}                                                

void AddPhotosButtonPress( GtkWidget *Widget, gpointer Data )
{
	/* Add some photos to this thing. */
        GSList* FileNames;
	GtkWidget *AddPhotosDialog;
	HildonFileSystemModel *model = NULL;
	GtkWidget *FileSelection;
	gchar *uri_type;
	gchar *file_name;

	if (PhotoOpenDir == NULL)
	{
		/* First load - fetch the settings from the file. */
		PhotoOpenDir = g_key_file_get_value(GUISettings, "default", "photoopendir", NULL);
	}

	/* Get the dialog ready. */
#if MAEMO_VERSION_MAJOR == 5
	AddPhotosDialog = gtk_dialog_new_with_buttons("Add photos...",
						      GTK_WINDOW(MatchWindow),
						      GTK_DIALOG_MODAL,
						      GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
						      GTK_STOCK_CANCEL,
						      GTK_RESPONSE_REJECT,
						      NULL);
	gtk_widget_set_size_request(AddPhotosDialog, -1, DIALOG_MIN_HEIGHTMAX);
	model=HILDON_FILE_SYSTEM_MODEL(g_object_new(HILDON_TYPE_FILE_SYSTEM_MODEL,
						    "ref_widget", GTK_WIDGET(MatchWindow), 
						    NULL));
	FileSelection = GTK_WIDGET(g_object_new
				   (HILDON_TYPE_FILE_SELECTION, 
				    "model", model, 
				    "edit-mode", TRUE, 
				    "local-only", TRUE, 
				    NULL));
	gtk_box_pack_start(GTK_BOX (GTK_DIALOG(AddPhotosDialog)->vbox), FileSelection, TRUE, TRUE, 0);
	hildon_file_selection_set_current_folder_uri(HILDON_FILE_SELECTION(FileSelection),
						     PhotoOpenDir, NULL);
	gtk_widget_show(FileSelection);
#else
	AddPhotosDialog = gtk_file_chooser_dialog_new ("Add Photos...",
			GTK_WINDOW(MatchWindow),
			GTK_FILE_CHOOSER_ACTION_OPEN,
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
			GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
			NULL);
	gtk_file_chooser_set_select_multiple(GTK_FILE_CHOOSER(AddPhotosDialog), TRUE);
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(AddPhotosDialog), PhotoOpenDir);
#endif

	/* Run the dialog. */
	if (gtk_dialog_run (GTK_DIALOG (AddPhotosDialog)) == GTK_RESPONSE_ACCEPT)
	{
		/* Hide the dialog. */
		gtk_widget_hide(AddPhotosDialog);
		/* Haul out the selected files.
		 * We pass them along to another function that will
		 * add them to the internal list and onto the screen. */
		/* GTK returns a GSList - a singly-linked list of filenames. */
#if MAEMO_VERSION_MAJOR == 5
		FileNames = hildon_file_selection_get_selected_uris (HILDON_FILE_SELECTION(FileSelection));
#else
		FileNames = gtk_file_chooser_get_filenames (GTK_FILE_CHOOSER(AddPhotosDialog));
#endif

		GSList* Run;
		for (Run = FileNames; Run; Run = Run->next)
		{
			/* Show whats happening on the screen. */
			GtkGUIUpdate();
			/*printf("Filename: %s.\n", (char*)Run->data);*/
			/* Call the other function with the filename - this
			 * function adds it to the internal list, and adds it
			 * to the screen display, too. */
			file_name = (char*)Run->data;
			uri_type = g_uri_parse_scheme(file_name);
			if(g_strcmp0(uri_type,"file") == 0) {
			  AddPhotoToList(file_name+7); /* Dirty! */
			}
			g_free(uri_type);
			/* Free the memory passed to us. */
			g_free(Run->data);
		}
		/* We're done with the list - free it. */
		g_slist_free(FileNames);
	}

	/* Copy out the directory that the user ended up at. */
	if (PhotoOpenDir)
	{
		g_free(PhotoOpenDir);
	}
#if MAEMO_VERSION_MAJOR == 5
	file_name = hildon_file_selection_get_current_folder_uri(HILDON_FILE_SELECTION(FileSelection));
	uri_type = g_uri_parse_scheme(file_name);
	PhotoOpenDir = g_strdup(file_name+7);
#else
	PhotoOpenDir = gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER(AddPhotosDialog));
#endif

	/* Now we're done with the dialog. See you! */
	gtk_widget_destroy (AddPhotosDialog);

}

void AddPhotoToList(char* Filename)
{
	/* Add the photo to the list. Query out the exif tags
	 * at the same time, too - so we can add them to the
	 * current list. */
	/* Note that this function does more than update the GUI:
	 * it also adds it to the internal list, ready to go. */
	
	/* Get ready to read the relevant data. */
	GtkTreeIter AddStuff;

	char* Time = NULL;
	double Lat, Long, Elev;
	Lat = Long = Elev = 0;
	int IncludesGPS = 0;

	/* Read the EXIF data. */
	Time = ReadExifData(Filename, &Lat, &Long, &Elev, &IncludesGPS);

	/* Note: we don't check if Time is NULL here. It is done for
	 * us in SetListItem, and we check again before we attempt
	 * to allocate memory to store "Time" in. */
		
	/* Add the data to the list. */
	gtk_list_store_append(PhotoListStore, &AddStuff);
	SetListItem(&AddStuff, Filename, Time, Lat, Long, Elev, NULL, IncludesGPS);

	/* Save away the filename and the TreeIter information in the internal
	 * singly-linked list. */
	/* We also make a copy of Filename - it won't exist once we return. */
	if (FirstPhoto)
	{
		/* Already at least one element. Add to it. */
		LastPhoto->Next = malloc(sizeof(struct GUIPhotoList));
		LastPhoto = LastPhoto->Next;
		LastPhoto->Next = NULL;
	} else {
		/* No elements. Righto, add one. */
		FirstPhoto = malloc(sizeof(struct GUIPhotoList));
		LastPhoto = FirstPhoto;
		FirstPhoto->Next = NULL;
	}

	/* Now that we've allocated memory for the structure, allocate
	 * memory for the strings and then fill them. */
	/* Filename first... */
	LastPhoto->Filename = malloc((sizeof(char) * strlen(Filename)) + 1);
	strncpy(LastPhoto->Filename, Filename, strlen(Filename) + 1);
	/* And then Time, after checking for NULLness. */
	if (Time)
	{
		LastPhoto->Time = malloc((sizeof(char) * strlen(Time)) + 1);
		strncpy(LastPhoto->Time, Time, strlen(Time));
	} else {
		LastPhoto->Time = malloc((sizeof(char) * strlen("No EXIF data")) + 1);
		strncpy(LastPhoto->Time, "No EXIF data", strlen("No EXIF data"));
	}
	/* Save the TreeIter as the last step. */
	LastPhoto->ListPointer = AddStuff;
	
	/* Save the pointer into the data, as well. */
	gtk_list_store_set(PhotoListStore, &AddStuff,
		LIST_POINTER, LastPhoto,
		-1);

	/* Free the memory allocated for us.
	 * (ReadExifData allocates and returns memory) */
	if (Time) free(Time);
}

void RemovePhotosButtonPress( GtkWidget *Widget, gpointer Data )
{
	/* Someone clicked the remove photos button. So make it happen!
	 * First, query out what was selected. */
	GtkTreeIter Iter;

	GtkTreeSelection* Selection;
	Selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(PhotoList));

	GList* Selected = gtk_tree_selection_get_selected_rows(Selection, NULL);

	/* Sanity check: was anything selected? */
	if (Selected == NULL)
	{
		/* Nothing is selected. Do nothing. */
		return;
	}

	/* Count the items on the GList. We need this to be able to
	 * keep a list of items that have been removed from our internal
	 * list, and should be removed from the screen. */
	int SelectedCount = 0;
	GList* Walk;
	for (Walk = Selected; Walk; Walk = Walk->next)
	{
		SelectedCount++;
	}

	/* Now get ready to keep a list of Iters that we can
	 * delete. */
	GtkTreeIter* RemoveIters = malloc(sizeof(GtkTreeIter) * SelectedCount);

	/* Walk through and remove the items from our internal list. */
	struct GUIPhotoList* PhotoWalk = NULL;
	struct GUIPhotoList* LastPhotoWalk = NULL;
	struct GUIPhotoList* FreeHold = NULL;
	struct GUIPhotoList* FreeMe = NULL;
	int IterCount = 0;
	for (Walk = Selected; Walk; Walk = Walk->next)
	{
		/* Acquire a new Iter for this selected row. */
		if (gtk_tree_model_get_iter(GTK_TREE_MODEL(PhotoListStore), &Iter, Walk->data))
		{
			/* To remove the row from our internal list.
			 * Locate it via the pointer stored. */
			gtk_tree_model_get(GTK_TREE_MODEL(PhotoListStore), &Iter,
					LIST_POINTER, &FreeMe, -1);
			/* Save the iter for afterwards: we can then remove the
			 * data from the screen. */
			/* gtk_list_store_remove(PhotoListStore, &Iter); */
			RemoveIters[IterCount] = Iter;
			IterCount++;
			/* Now go back through and take it out from our list. */
			PhotoWalk = FirstPhoto;
			LastPhotoWalk = NULL;
			while (1)
			{
				if (PhotoWalk == NULL) break;
				/*printf("Search: %d / %d.\n", PhotoWalk, FreeMe);*/
				/* Check to see if this is the one we want to be rid of. */
				if (PhotoWalk == FreeMe)
				{
					/* Right. Remove. */
					/*printf("Removing: %s.\n", PhotoWalk->Filename);*/
					PhotoWalk = PhotoWalk->Next;
					if (FreeMe == FirstPhoto)
					{
						/* Remove the top of the list. */
						FreeHold = FreeMe;
						FirstPhoto = FreeMe->Next;
						LastPhotoWalk = FreeMe->Next;
						free(FreeHold->Filename);
						free(FreeHold->Time);
						free(FreeHold);
						break;
					} else if (FreeMe == LastPhoto) {
						/* Remove the bottom of the list. */
						FreeHold = FreeMe;
						LastPhoto = LastPhotoWalk;
						LastPhoto->Next = NULL;
						free(FreeHold->Filename);
						free(FreeHold->Time);
						free(FreeHold);
						break;
					} else {
						/* Remove a middle of the list. */
						FreeHold = FreeMe;
						LastPhotoWalk->Next = FreeHold->Next;
						free(FreeHold->Filename);
						free(FreeHold->Time);
						free(FreeHold);
						break;
					}
				} else {
					/* Nope, this wasn't what we wanted to delete.
					 * So get ready to look at the next one, keeping
					 * mind of where we were. */
					LastPhotoWalk = PhotoWalk;
					PhotoWalk = PhotoWalk->Next;
				}
			} /* End for Walk the photo list. */
			
		}
	} /* End for Walk the GList. */

	/* Now remove the rows from the screen. 
	 * By this point, they are no longer in our internal list. */
	int i;
	for (i = 0; i < SelectedCount; i++)
	{
		gtk_list_store_remove(PhotoListStore, &RemoveIters[i]);
	}
	free(RemoveIters);

	/* Free the memory used by GList. */
	g_list_foreach(Selected, (GFunc)gtk_tree_path_free, NULL);
	g_list_free(Selected);

	/* Debug: walk the photo list tree. */
	/*struct GUIPhotoList* List;
	for (List = FirstPhoto; List; List = List->Next)
	{
		printf("List Filename: %s\n", List->Filename);
	}
	printf("--------------------------------------------------------------\n");*/

}

void SetListItem(GtkTreeIter* Iter, char* Filename, char* Time, double Lat,
		double Long, double Elev, char* PassedState, int IncludesGPS)
{
	/* Scratch areas. */
	char LatScratch[100];
	char LongScratch[100];
	char ElevScratch[100];
	char* State = NULL;
	strncpy(LatScratch, "", 100);
	strncpy(LongScratch, "", 100);
	strncpy(ElevScratch, "", 100);
	
	/* Format all the data. */
	if (!Time)
	{
		/* Not good. Failure. */
		Time = "";
		State = "No EXIF data";
	} else {
		/* All ok. Get ready. */
		if (IncludesGPS)
		{
			State = "GPS Data Present";
			/* In each case below, consider the values
			 * that are invalid for each - if that's the case,
			 * consider the spots as "blank". */
			/* Lat can't be greater than 90 degrees. */
			if (Lat < 200)
			{
				snprintf(LatScratch, 100, "%f (%c)",
					Lat, (Lat < 0) ? 'S' : 'N');
			} else {
				snprintf(LatScratch, 100, " ");
			}
			/* Long can't be greater than 180 degrees. */
			if (Long < 200)
			{
				snprintf(LongScratch, 100, "%f (%c)",
					Long, (Long < 0) ? 'W' : 'E');
			} else {
				snprintf(LongScratch, 100, " ");
			}
			/* Radius of earth ~6000km */
			if (Elev > -7000000)
			{
				snprintf(ElevScratch, 100, "%fm", Elev);
			} else {
				snprintf(ElevScratch, 100, " ");
			}
		} else {
			/* Placeholders for the lack of data. */
			State = "Ready";
		}
	}

	/* Overwrite state with what we want, if needed. */
	if (PassedState) State = PassedState;
	/* And set all the appropriate data. */
	gtk_list_store_set(PhotoListStore, Iter,
		LIST_FILENAME, strrchr(Filename, G_DIR_SEPARATOR)+1,
		LIST_STATE, State,
		LIST_LAT, LatScratch,
		LIST_LONG, LongScratch,
		LIST_ELEV, ElevScratch,
		LIST_TIME, Time,
		-1);
	
}

void SetState(GtkTreeIter* Iter, char* State)
{
	/* Set the state on the item... just the state. */
	gtk_list_store_set(PhotoListStore, Iter,
		LIST_STATE, State,
		-1);
}


void SelectGPSButtonPress( GtkWidget *Widget, gpointer Data )
{
	/* Select and load some GPS data! */
	GtkWidget *GPSDataDialog;
	GtkWidget *ErrorDialog;
	char* FileName;
	char* Scratch;
	
	if (GPXOpenDir == NULL)
	{
		/* First load - fetch the settings from the file. */
		GPXOpenDir = g_key_file_get_value(GUISettings, "default", "gpxopendir", NULL);
	}

	/* Get the dialog ready... */
#if MAEMO_VERSION_MAJOR == 5
	GPSDataDialog = hildon_file_chooser_dialog_new(GTK_WINDOW(MatchWindow),
						       GTK_FILE_CHOOSER_ACTION_OPEN);

	gtk_file_chooser_set_select_multiple(GTK_FILE_CHOOSER(GPSDataDialog), FALSE);
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(GPSDataDialog), GPXOpenDir);
#else
	GPSDataDialog = gtk_file_chooser_dialog_new ("Select GPS Data...",
			GTK_WINDOW(MatchWindow),
			GTK_FILE_CHOOSER_ACTION_OPEN,
			GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
			GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
			NULL);
#endif

	/* Run the dialog... */
#if MAEMO_VERSION_MAJOR == 5
	if (gtk_dialog_run (GTK_DIALOG (GPSDataDialog)) == GTK_RESPONSE_OK)
#else
	if (gtk_dialog_run (GTK_DIALOG (GPSDataDialog)) == GTK_RESPONSE_ACCEPT)
#endif
	{
		/* Process the result of the dialog... */
		FileName = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(GPSDataDialog));

		/* Sanity check: do we already have data?
		 * Note: we check this now, because if we cancelled the dialog,
		 * we should run with the old data. */
		if (GPSData)
		{
			/* We already had GPS data. Free that first. */
			FreePointList(GPSData);
		}

		/* Prepare our "scratch" for rewriting labels. */
		Scratch = malloc(sizeof(char) * (strlen(FileName) + 100));

		/* Hide the "open" dialog. */
		gtk_widget_hide(GPSDataDialog);

		/* Display a dialog so the user knows whats going down. */
#if MAEMO_VERSION_MAJOR == 5
		hildon_banner_show_information(GTK_WIDGET(MatchWindow), NULL, 
					       "Loading GPS data from file... Won't be a moment...");
#else
		ErrorDialog = gtk_message_dialog_new (GTK_WINDOW(MatchWindow),
			GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL,
			GTK_MESSAGE_INFO,
			0,
			"Loading GPS data from file... Won't be a moment...");
		gtk_widget_show(ErrorDialog);
#endif
		GtkGUIUpdate();
		 
		/* Read in the new data... assuming we can. */
		GPSData = ReadGPX(FileName);

		/* Close the dialog now we're done. */
#ifndef MAEMO_VERSION_MAJOR
		gtk_widget_destroy(ErrorDialog);
#endif

		/* Check if the data was read ok. */
		if (GPSData)
		{
			/* It's all good!
			 * Adjust the label to say so. */
#if MAEMO_VERSION_MAJOR == 5

		  /* Update the menu button */
		  hildon_button_set_value(HILDON_BUTTON(mm_sel_gpx), strrchr(FileName, G_DIR_SEPARATOR)+1);
#else
			snprintf(Scratch, strlen(FileName)+100, 
					"Read from: %s", strrchr(FileName, G_DIR_SEPARATOR)+1);
			gtk_label_set_text(GTK_LABEL(GPSSelectedLabel), Scratch);
#endif
		} else {
			/* Not good. Say so. */
			/* Set the label... */
#if MAEMO_VERSION_MAJOR == 5
		  hildon_button_set_value(HILDON_BUTTON(mm_sel_gpx), "(not chosen)");
#else
			snprintf(Scratch, strlen(FileName)+100, 
					"Reading from: No file");
			gtk_label_set_text(GTK_LABEL(GPSSelectedLabel), Scratch);
#endif
			/* Show an error dialog. */
#if MAEMO_VERSION_MAJOR == 5
			snprintf(Scratch,strlen(FileName)+56,
				 "Unable to read file %s for some reason. Please try again",
				 FileName);
			hildon_banner_show_information(GTK_WIDGET(MatchWindow), NULL, Scratch);
#else
			ErrorDialog = gtk_message_dialog_new (GTK_WINDOW(MatchWindow),
					GTK_DIALOG_DESTROY_WITH_PARENT,
					GTK_MESSAGE_ERROR,
					GTK_BUTTONS_CLOSE,
					"Unable to read file %s for some reason. Please try again",
					FileName);
			gtk_dialog_run (GTK_DIALOG (ErrorDialog));
			gtk_widget_destroy (ErrorDialog);
#endif
		}
		
		/* Clean up... */
		free(Scratch);
		g_free(FileName);
	}

	/* Make a note of the directory we stopped at. */
	if (GPXOpenDir)
	{
		g_free(GPXOpenDir);
	}
	GPXOpenDir = gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER(GPSDataDialog));

	/* Now we're finished with the dialog... free it. */
	gtk_widget_destroy (GPSDataDialog);

}

#if MAEMO_VERSION_MAJOR == 5
void SelectOptionsButtonPress( GtkWidget *Widget, gpointer Data )
{
  GtkWidget *dialog;
  GtkWidget *vbox;
  GtkWidget *svbox;
  GtkWidget *scrollwin;

  dialog = gtk_dialog_new_with_buttons("Options",
				       GTK_WINDOW(MatchWindow),
				       GTK_DIALOG_MODAL,
				       GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
				       GTK_STOCK_CANCEL,
				       GTK_RESPONSE_REJECT,
				       NULL);
  gtk_widget_set_size_request(dialog, -1, DIALOG_MIN_HEIGHTMAX);

  vbox = GTK_WIDGET(GTK_DIALOG(dialog)->vbox);

  scrollwin = hildon_pannable_area_new();
  gtk_box_pack_start (GTK_BOX (vbox), scrollwin, TRUE, TRUE, 0);
  svbox = gtk_vbox_new (FALSE, 0);

  options_interpolate_check = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
  gtk_button_set_label(GTK_BUTTON (options_interpolate_check),"Interpolate");
  hildon_check_button_set_active(HILDON_CHECK_BUTTON (options_interpolate_check), g_key_file_get_boolean(GUISettings, "default", "interpolate", NULL));
  gtk_box_pack_start (GTK_BOX(svbox), options_interpolate_check, TRUE, TRUE, 0);
  gtk_widget_show(options_interpolate_check);

  options_dontwrite_check = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
  gtk_button_set_label(GTK_BUTTON (options_dontwrite_check),"Don't write");
  hildon_check_button_set_active(HILDON_CHECK_BUTTON (options_dontwrite_check), g_key_file_get_boolean(GUISettings, "default", "dontwrite", NULL));
  gtk_box_pack_start (GTK_BOX(svbox), options_dontwrite_check, TRUE, TRUE, 0);
  gtk_widget_show(options_dontwrite_check);

  options_nomtime_check = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
  gtk_button_set_label(GTK_BUTTON (options_nomtime_check),"Don't change mtime");
  hildon_check_button_set_active(HILDON_CHECK_BUTTON (options_nomtime_check), g_key_file_get_boolean(GUISettings, "default", "nochangemtime", NULL));
  gtk_box_pack_start (GTK_BOX(svbox), options_nomtime_check, TRUE, TRUE, 0);
  gtk_widget_show(options_nomtime_check);

  options_betweensegments_check = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
  gtk_button_set_label(GTK_BUTTON (options_betweensegments_check),"Between Segments");
  hildon_check_button_set_active(HILDON_CHECK_BUTTON (options_betweensegments_check), g_key_file_get_boolean(GUISettings, "default", "betweensegments", NULL));
  gtk_box_pack_start (GTK_BOX(svbox), options_betweensegments_check, TRUE, TRUE, 0);
  gtk_widget_show(options_betweensegments_check);

  options_degminsecs_check = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
  gtk_button_set_label(GTK_BUTTON (options_degminsecs_check),"Write DD MM SS.SS");
  hildon_check_button_set_active(HILDON_CHECK_BUTTON (options_degminsecs_check), g_key_file_get_boolean(GUISettings, "default", "writeddmmss", NULL));
  gtk_box_pack_start (GTK_BOX(svbox), options_degminsecs_check, TRUE, TRUE, 0);
  gtk_widget_show(options_degminsecs_check);

  options_options_table = gtk_table_new (4, 2, FALSE);
  gtk_box_pack_start (GTK_BOX(svbox), options_options_table, TRUE, TRUE, 0);

  options_maxgaptime_label = gtk_label_new ("Max gap time:");
  gtk_table_attach(GTK_TABLE(options_options_table), options_maxgaptime_label, 0, 1, 0, 1,
		   GTK_EXPAND|GTK_FILL,
		   0, 0, 5);
  gtk_widget_show (options_maxgaptime_label);

  options_maxgaptime_entry = hildon_entry_new(HILDON_SIZE_FINGER_HEIGHT);
  gtk_entry_set_text (GTK_ENTRY (options_maxgaptime_entry), g_key_file_get_value(GUISettings, "default", "maxgap", NULL));
  gtk_table_attach(GTK_TABLE(options_options_table), options_maxgaptime_entry, 1, 2, 0, 1,
		   GTK_EXPAND|GTK_FILL,
		   0, 0, 5);
  gtk_widget_show (options_maxgaptime_entry);

  options_timezone_label = gtk_label_new ("Time Zone:");
  gtk_table_attach(GTK_TABLE(options_options_table), options_timezone_label, 0, 1, 1, 2,
		   GTK_EXPAND|GTK_FILL,
		   0, 0, 5);
  gtk_widget_show (options_timezone_label);

  options_timezone_entry = hildon_entry_new(HILDON_SIZE_FINGER_HEIGHT);
  gtk_entry_set_text (GTK_ENTRY (options_timezone_entry), g_key_file_get_value(GUISettings, "default", "timezone", NULL));
  gtk_table_attach(GTK_TABLE(options_options_table), options_timezone_entry, 1, 2, 1, 2,
		   GTK_EXPAND|GTK_FILL,
		   0, 0, 5);
  gtk_widget_show (options_timezone_entry);

  options_photooffset_label = gtk_label_new ("Photo Offset:");
  gtk_table_attach(GTK_TABLE(options_options_table), options_photooffset_label, 0, 1, 2, 3,
		   GTK_EXPAND|GTK_FILL,
		   0, 0, 5);
  gtk_widget_show (options_photooffset_label);

  options_photooffset_entry = hildon_entry_new(HILDON_SIZE_FINGER_HEIGHT);
  gtk_entry_set_text (GTK_ENTRY (options_photooffset_entry), g_key_file_get_value(GUISettings, "default", "photooffset", NULL));
  gtk_table_attach(GTK_TABLE(options_options_table), options_photooffset_entry, 1, 2, 2, 3,
		   GTK_EXPAND|GTK_FILL,
		   0, 0, 5);
  gtk_widget_show (options_photooffset_entry);

  options_gpsdatum_label = gtk_label_new ("GPS Datum:");
  gtk_table_attach(GTK_TABLE(options_options_table), options_gpsdatum_label, 0, 1, 3, 4,
		   GTK_EXPAND|GTK_FILL,
		   0, 0, 5);
  gtk_widget_show (options_gpsdatum_label);

  options_gpsdatum_entry = hildon_entry_new(HILDON_SIZE_FINGER_HEIGHT);
  gtk_entry_set_text (GTK_ENTRY (options_gpsdatum_entry), g_key_file_get_value(GUISettings, "default", "gpsdatum", NULL));
  gtk_table_attach(GTK_TABLE(options_options_table), options_gpsdatum_entry, 1, 2, 3, 4,
		   GTK_EXPAND|GTK_FILL,
		   0, 0, 5);
  gtk_widget_show (options_gpsdatum_entry);

  gtk_widget_show(options_options_table);

  gtk_widget_show(svbox);
  hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(scrollwin),svbox);
  gtk_widget_show(scrollwin);

  gtk_widget_show(dialog);
  if (gtk_dialog_run(GTK_DIALOG(dialog))==GTK_RESPONSE_ACCEPT) {
    g_key_file_set_boolean(GUISettings, "default", "interpolate", hildon_check_button_get_active (HILDON_CHECK_BUTTON (options_interpolate_check)));
    g_key_file_set_boolean(GUISettings, "default", "dontwrite", hildon_check_button_get_active (HILDON_CHECK_BUTTON (options_dontwrite_check)));
    g_key_file_set_boolean(GUISettings, "default", "nochangemtime", hildon_check_button_get_active (HILDON_CHECK_BUTTON (options_nomtime_check)));
    g_key_file_set_boolean(GUISettings, "default", "betweensegments", hildon_check_button_get_active (HILDON_CHECK_BUTTON (options_betweensegments_check)));
    g_key_file_set_boolean(GUISettings, "default", "writeddmmss", hildon_check_button_get_active (HILDON_CHECK_BUTTON (options_degminsecs_check)));
    g_key_file_set_string(GUISettings, "default", "maxgap", gtk_entry_get_text(GTK_ENTRY(options_maxgaptime_entry)));
    g_key_file_set_string(GUISettings, "default", "timezone", gtk_entry_get_text(GTK_ENTRY(options_timezone_entry)));
    g_key_file_set_string(GUISettings, "default", "photooffset", gtk_entry_get_text(GTK_ENTRY(options_photooffset_entry)));
    g_key_file_set_string(GUISettings, "default", "gpsdatum", gtk_entry_get_text(GTK_ENTRY(options_gpsdatum_entry)));
  }
  gtk_widget_destroy(GTK_WIDGET(dialog));
}

void tool_button_set_icon_name(GtkToolButton *button, const gchar *icon_name)
{
  GtkWidget *image;
  image = gtk_image_new_from_icon_name(icon_name, GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_tool_button_set_icon_widget(button, image);
}

void CreateToolbar(HildonWindow *main_window)
{
  toolbar = gtk_toolbar_new();

  toolbar_add = gtk_tool_button_new(NULL, NULL);
  tool_button_set_icon_name(GTK_TOOL_BUTTON(toolbar_add), "general_add");

  toolbar_delete = gtk_tool_button_new(NULL, NULL);
  tool_button_set_icon_name(GTK_TOOL_BUTTON(toolbar_delete), "general_delete");

  toolbar_settings = gtk_tool_button_new(NULL, NULL);
  tool_button_set_icon_name(GTK_TOOL_BUTTON(toolbar_settings), "general_settings");

  toolbar_correlate = gtk_tool_button_new_from_stock(GTK_STOCK_EXECUTE);

  gtk_tool_item_set_expand(GTK_TOOL_ITEM(toolbar_add),TRUE);
  gtk_tool_item_set_expand(GTK_TOOL_ITEM(toolbar_delete),TRUE);
  gtk_tool_item_set_expand(GTK_TOOL_ITEM(toolbar_settings),TRUE);
  gtk_tool_item_set_expand(GTK_TOOL_ITEM(toolbar_correlate),TRUE);

  gtk_toolbar_insert(GTK_TOOLBAR(toolbar), toolbar_add, -1);
/*   gtk_toolbar_insert(GTK_TOOLBAR(toolbar), gtk_separator_tool_item_new(), -1); */
  gtk_toolbar_insert(GTK_TOOLBAR(toolbar), toolbar_delete, -1);
/*   gtk_toolbar_insert(GTK_TOOLBAR(toolbar), gtk_separator_tool_item_new(), -1); */
  gtk_toolbar_insert(GTK_TOOLBAR(toolbar), toolbar_settings, -1);
/*   gtk_toolbar_insert(GTK_TOOLBAR(toolbar), gtk_separator_tool_item_new(), -1); */
  gtk_toolbar_insert(GTK_TOOLBAR(toolbar), toolbar_correlate, -1);

  g_signal_connect(G_OBJECT(toolbar_add), "clicked",
		   G_CALLBACK(AddPhotosButtonPress), NULL);
  g_signal_connect(G_OBJECT(toolbar_delete), "clicked",
		   G_CALLBACK(RemovePhotosButtonPress), NULL);
  g_signal_connect(G_OBJECT(toolbar_settings), "clicked",
		   G_CALLBACK(SelectOptionsButtonPress), NULL);
  g_signal_connect(G_OBJECT(toolbar_correlate), "clicked",
		   G_CALLBACK(CorrelateButtonPress), NULL);

  gtk_widget_show_all(toolbar);
  hildon_window_add_toolbar(main_window, GTK_TOOLBAR(toolbar));
}
#endif

void CorrelateButtonPress( GtkWidget *Widget, gpointer Data )
{
	/* We were asked to correlate some photos... make it happen... */
	GtkWidget *ErrorDialog;

	/* Check to see we have everything we need... */
	if (FirstPhoto == NULL)
	{
		/* No photos... */
#if MAEMO_VERSION_MAJOR == 5
	  hildon_banner_show_information(GTK_WIDGET(MatchWindow), NULL, 
					 "No photos selected to match! Please add photos with first!");
#else
		ErrorDialog = gtk_message_dialog_new (GTK_WINDOW(MatchWindow),
				GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_ERROR,
				GTK_BUTTONS_CLOSE,
				"No photos selected to match! Please add photos with first!");
		gtk_dialog_run (GTK_DIALOG (ErrorDialog));
		gtk_widget_destroy (ErrorDialog);
#endif
		return;
	}

	if (GPSData == NULL)
	{
		/* No GPS data... */
#if MAEMO_VERSION_MAJOR == 5
	  hildon_banner_show_information(GTK_WIDGET(MatchWindow), NULL, 
					 "No GPS data loaded! Please select a file to read GPS data from.");
#else
		ErrorDialog = gtk_message_dialog_new (GTK_WINDOW(MatchWindow),
				GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_MESSAGE_ERROR,
				GTK_BUTTONS_CLOSE,
				"No GPS data loaded! Please select a file to read GPS data from.");
		gtk_dialog_run (GTK_DIALOG (ErrorDialog));
		gtk_widget_destroy (ErrorDialog);
		return;
#endif
	}

	/* Assemble the settings for the correlation run. */
	struct CorrelateOptions Options;
	char* DatumScratch = NULL;

	/* Interpolation. */
	/* This is confusing. I should have thought more about the Interpolate
	 * flags in the CorrelateOptions structure. But, if you think about
	 * it for a bit, it can make sense. Enough sense to use.  */
/* 	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(InterpolateCheck))) */
	if (g_key_file_get_boolean(GUISettings, "default", "interpolate", NULL))
	{
		Options.NoInterpolate = 0;
	} else {
		Options.NoInterpolate = 1;
	}

	/* Write or no write. */
/* 	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(NoWriteCheck))) */
	if (g_key_file_get_boolean(GUISettings, "default", "dontwrite", NULL))
	{
		Options.NoWriteExif = 1;
	} else {
		Options.NoWriteExif = 0;
	}

	/* No change MTime. */
/* 	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(NoMtimeCheck))) */
	if (g_key_file_get_boolean(GUISettings, "default", "nochangemtime", NULL))
	{
		Options.NoChangeMtime = 1;
	} else {
		Options.NoChangeMtime = 0;
	}

	/* Between segments? */
/* 	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(BetweenSegmentsCheck))) */
	if (g_key_file_get_boolean(GUISettings, "default", "betweensegments", NULL))
	{
		Options.DoBetweenTrkSeg = 1;
	} else {
		Options.DoBetweenTrkSeg = 0;
	}

	/* DD MM.MM or DD MM SS.SS? */
/* 	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(DegMinSecsCheck))) */
	if (g_key_file_get_boolean(GUISettings, "default", "writeddmmss", NULL))
	{
		Options.DegMinSecs = 1;
	} else {
		Options.DegMinSecs = 0;
	}
	
	/* Feather time. */
/* 	Options.FeatherTime = atof(gtk_entry_get_text(GTK_ENTRY(GapTimeEntry))); */
	Options.FeatherTime = atof(g_key_file_get_value(GUISettings, "default", "maxgap", NULL));

	/* GPS Datum. */
/* 	DatumScratch = malloc(sizeof(char) * (strlen(gtk_entry_get_text(GTK_ENTRY(GPSDatumEntry))) + 1)); */
	DatumScratch = malloc(sizeof(char) * (strlen(g_key_file_get_value(GUISettings, "default", "gpsdatum", NULL)) + 1));
/* 	strcpy(DatumScratch, gtk_entry_get_text(GTK_ENTRY(GPSDatumEntry))); */
	strcpy(DatumScratch, g_key_file_get_value(GUISettings, "default", "gpsdatum", NULL));
	Options.Datum = DatumScratch;
		
	/* TimeZone. We may need to extract the timezone from a string. */
	Options.TimeZoneHours = 0;
	Options.TimeZoneMins = 0;
/* 	char* TZString = (char*) gtk_entry_get_text(GTK_ENTRY(TimeZoneEntry)); */
	char* TZString = (char*) g_key_file_get_value(GUISettings, "default", "timezone", NULL);
	/* Check the string. If there is a colon, then it's a time in xx:xx format.
	 * If not, it's probably just a +/-xx format. In all other cases,
	 * it will be interpreted as +/-xx, which, if given a string, returns 0. */
	if (strstr(TZString, ":"))
	{
		/* Found colon. Split into two. */
		sscanf(TZString, "%d:%d", &Options.TimeZoneHours, &Options.TimeZoneMins);
		if (Options.TimeZoneHours < 0)
		    Options.TimeZoneMins *= -1;
	} else {
		/* No colon. Just parse. */
		Options.TimeZoneHours = atoi(TZString);
	}

	/* Photo Offset time */
/* 	Options.PhotoOffset = atoi(gtk_entry_get_text(GTK_ENTRY(PhotoOffsetEntry))); */
	Options.PhotoOffset = atoi(g_key_file_get_value(GUISettings, "default", "photooffset", NULL));

	/* Clean up some other pointers in the structure. */
	Options.MinTime = 0;
	Options.MaxTime = 0;

	Options.Points = GPSData;

	/* Walk through the list, correlating, and updating the screen. */
	struct GUIPhotoList* Walk;
	struct GPSPoint* Result;
	char* State;
	GtkTreePath* ShowPath;
	for (Walk = FirstPhoto; Walk; Walk = Walk->Next)
	{
		/* Say that we're doing it... */
		SetState(&Walk->ListPointer, "Correlating...");

		/* Point to the cell, too... ie, scroll the tree view
		 * to ensure that the one we're playing with can be seen on screen. */
		ShowPath = gtk_tree_model_get_path(GTK_TREE_MODEL(PhotoListStore), &Walk->ListPointer);
		gtk_tree_view_scroll_to_cell(GTK_TREE_VIEW(PhotoList),
				ShowPath, NULL, FALSE, 0, 0);
		gtk_tree_path_free(ShowPath);
		GtkGUIUpdate();
		
		/* Do the correlation. */
		Result = CorrelatePhoto(Walk->Filename, &Options);
		
		/* Figure out if it worked. */
		if (Result)
		{
			/* Result was not null. That means that we
			 * matched to a point. But that's not the whole
			 * story. Read on... */
			switch (Options.Result)
			{
				case CORR_OK:
					/* All cool! Exact match! */
					State = "Exact Match";
					break;
				case CORR_INTERPOLATED:
					/* All cool! Interpolated match. */
					State = "Interpolated Match";
					break;
				case CORR_ROUND:
					/* All cool! Rounded match. */
					State = "Rounded Match";
					break;
				case CORR_EXIFWRITEFAIL:
					/* Not cool - matched, not written. */
					State = "Write Failure";
					break;
			}
			/* Now update the screen with the numbers. */
			SetListItem(&Walk->ListPointer, Walk->Filename,
					Walk->Time, Result->Lat, Result->Long,
					Result->Elev, State, 1);
		} else {
			/* Result was null. This means something
			 * really went wrong. Find out and put that
			 * on the screen. */
			if (Options.Result == CORR_GPSDATAEXISTS)
			{
				/* Do nothing... */
				SetState(&Walk->ListPointer, "Data Already Present");
				continue;
			}
			switch (Options.Result)
			{
				case CORR_NOMATCH:
					/* No match: outside data. */
					State = "No Match";
					break;
				case CORR_TOOFAR:
					/* Too far from any point. */
					State = "Too far";
					break;
				case CORR_NOEXIFINPUT:
					/* No exif data input. */
					State = "No data";
					break;
			}
			/* Now update the screen with the changed state. */
			SetListItem(&Walk->ListPointer, Walk->Filename,
					Walk->Time, 0, 0, 0,
					State, 0);
		} /* End if Result */
	} /* End for Walk the list ... */

	/* Free the memory used to shuffle around the Datum. */
	free(DatumScratch);
}

void StripGPSButtonPress( GtkWidget *Widget, gpointer Data )
{
  GtkWidget *confirmdlg;
  gint confirm;

  confirmdlg=hildon_note_new_confirmation(GTK_WINDOW(MatchWindow), 
					  "Are you sure that you want to remove all the GPS tags from all the selected files");
  confirm = gtk_dialog_run(GTK_DIALOG(confirmdlg));
  gtk_widget_destroy(GTK_WIDGET(confirmdlg));

  if(confirm == GTK_RESPONSE_OK) {

	/* Someone clicked the Strip GPS Data button. So make it happen!
	 * First, query out what was selected. */
	GtkTreeIter Iter;

#ifndef MAEMO_VERSION_MAJOR
	GtkTreeSelection* Selection;
	Selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(PhotoList));

	GList* Selected = gtk_tree_selection_get_selected_rows(Selection, NULL);

	/* Sanity check: was anything selected? */
	if (Selected == NULL)
	{
		/* Nothing is selected. Do nothing. */
	  g_print("No list\n");
		return;
	}
#endif

	/* No change MTime. */
	int NoChangeMtime;
/* 	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(NoMtimeCheck))) */
	if (g_key_file_get_boolean(GUISettings, "default", "nochangemtime", NULL))
	{
		NoChangeMtime = 1;
	} else {
		NoChangeMtime = 0;
	}

	/* Walk through and remove the items from our internal list. */
	GList* Walk;
	struct GUIPhotoList* PhotoData = NULL;
	GtkTreePath* ShowPath;
	if (gtk_tree_model_get_iter_first(GTK_TREE_MODEL(PhotoListStore), &Iter))
/* 	for (Walk = Selected; Walk; Walk = Walk->next) */
	do
	{
		/* Get an Iter for this selected row. */
/* 		if (gtk_tree_model_get_iter(GTK_TREE_MODEL(PhotoListStore), &Iter, Walk->data)) { */
		if (1) {
			/* Fetch out the data... */
			gtk_tree_model_get(GTK_TREE_MODEL(PhotoListStore), &Iter, LIST_POINTER, &PhotoData, -1);
		} else {
			/* Unable to get the iter...
			 * Try again, later. */
			continue;
		}

		/* Say that we're doing it... */
		SetState(&PhotoData->ListPointer, "Stripping...");

		/* Point to the cell, too... ie, scroll the tree view
		 * to ensure that the one we're playing with can be seen on screen. */
		ShowPath = gtk_tree_model_get_path(GTK_TREE_MODEL(PhotoListStore), &PhotoData->ListPointer);
		gtk_tree_view_scroll_to_cell(GTK_TREE_VIEW(PhotoList),
				ShowPath, NULL, FALSE, 0, 0);
		gtk_tree_path_free(ShowPath);
		GtkGUIUpdate();
		
		/* Strip the tags. */
		if (RemoveGPSExif(PhotoData->Filename, NoChangeMtime))
		{
			SetListItem(&PhotoData->ListPointer, PhotoData->Filename,
				PhotoData->Time, 200, 200, -7000000, "", 1);
		} else {
			SetListItem(&PhotoData->ListPointer, PhotoData->Filename,
				PhotoData->Time, 200, 200, -7000000, "Error Stripping", 1);
		}

	} /* End for Walk the GList. */
	while (gtk_tree_model_iter_next(GTK_TREE_MODEL(PhotoListStore), &Iter));

	/* Debug: walk the photo list tree. */
	/*struct GUIPhotoList* List;
	for (List = FirstPhoto; List; List = List->Next)
	{
		printf("List Filename: %s\n", List->Filename);
	}
	printf("--------------------------------------------------------------\n");*/
  }

}


void GtkGUIUpdate(void)
{
	/* Process all GUI events that need to happen. */
	/* This lets us "update" the screen while things are
	 * in motion. Might generate slowdowns with heaps of data,
	 * but generally, it's a good thing. */
	while (gtk_events_pending ())
		gtk_main_iteration ();
};
