#!/usr/bin/env python

from daap import DAAPClient

import sys


class DAAPProxy(object):
    def __init__( self, host, port = 3689):
        self.host = host
        self.port = port

        self.client = DAAPClient()
        self.client.connect( host, port)
        self.session = self.client.login()
        self.databases = self.session.databases()

        libid = self.session.library().id
        self.database = None
        for d in self.databases:
            if str( d.id) == str( id):
                self.database = d

        if self.database is None:
            self.database = d

        self.tracks = self.database.tracks()

    def generate_url( self, track):
        return 'http://%s:%d/databases/%d/items/%d.%s?session-id=%d' % ( self.host, self.port, self.database.id, track.id, track.type, self.session.sessionid )

    def print_rss( self, file = sys.stdout):
        file.write( '<?xml version="1.0"?>\n')
        file.write( '<rss version="2.0">\n')
        file.write( '<channel>\n')
        file.write( '<title>%s (daap)</title>\n' % ( self.host ))
        file.write( '<description>Live RSS feed generated by DAAP-Proxy.</description>\n')
        file.write( '<link>http://%s:%s/</link>\n' % ( self.host, self.port ))
        for t in self.tracks:
            try:
                name = ascii( '%s - %s' % ( t.artist, t.name ))
            except:
                name = '%s - %s' % ( repr( t.artist), repr( t.name) )

            file.write( '<item>\n')
            file.write( '<title>%s</title>\n' % ( name ))
            file.write( '<description>%s</description>\n' % ( name ))
            file.write( '<enclosure url="%s" length="0" type="audio/mpeg"/>\n' % ( self.generate_url( t) ))
            file.write( '</item>\n')
        file.write( '</channel>\n')


# testing code
proxy = DAAPProxy( "ignition")
proxy.print_rss()
proxy.print_rss( open( "test.rss", "w"))
sys.stdin.readline()

