/*
 * Copyright (C) 2005 Luca De Cicco <ldecicco@gmail.com>
 * Hildonized by Luca De Cicco
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#ifndef _SUDOKU_WORKSHEET_H__
#define _SUDOKU_WORKSHEET_H__

#include <glib.h>
#include <gtk/gtk.h>
#include "actions.h"
#include "guesses.h"

struct sudoku_big_square {
	GtkWidget *drawing; /* Draw here! */
	GtkWidget *container; /* Draw here! */
	GdkRectangle squares[9];
	guint width;
	guint height;
	gint index;
	
};

struct sudoku_cell {
   guint cell; /* Value from 1 to 9 */
   GSList *guesses;  /* List of guess for this cell */
   gboolean fixed; /* If TRUE this is a fixed cell, i.e. it is
		      a cell of the initial puzzle */
};

struct sudoku_worksheet {
	/* nine Big Squares */
	struct sudoku_big_square *bs[9];
	/* Single cells */
	struct sudoku_cell *s_cells[81];
	/* Actions made by the player, this is useful when performing undo */
	 
	GSList *actions;
	guint width;
	guint height;
	/* If true, there are some changes in the worksheet which are 
	 * not saved
	 */
	gboolean changed_since_saved;
};

#define GET_ROW(cell) cell/9
#define GET_COL(cell) cell%9


struct sudoku_big_square *
sudoku_big_square_new(guint width, guint height, 
                        gint index, GtkWidget *container);

struct sudoku_worksheet *
sudoku_worksheet_new(guint width, guint height, 
		     GtkWidget *container);	

void 
sudoku_worksheet_add_guess(struct sudoku_worksheet *ws,guint index,
			   guint value);


void 
sudoku_worksheet_flush_guesses(struct sudoku_worksheet *ws, 
				guint index);

void 
sudoku_worksheet_resize(struct sudoku_worksheet *board, 
			guint width, guint height);
#endif
