/*
 * Copyright (C) 2005 Luca De Cicco <ldecicco@gmail.com>
 * Hildonized by Luca De Cicco
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#include <glib.h>
#include "callbacks.h"
#include "sudoku_worksheet.h"

struct sudoku_big_square *sudoku_big_square_new(guint width, guint height, gint index, GtkWidget *container)
{
	struct sudoku_big_square *bs;
	gint i;
	
	bs = g_malloc(sizeof(struct sudoku_big_square));
	
	bs->index = index;
	bs->width = width/3;
	bs->height = height/3;
		
	bs->container = container;
	
	for(i = 0 ; i < 9 ; i++){
		gint offset_x, offset_y;
		offset_x = i%3 * bs->width/3;
		offset_y = (i/3) * (bs->height/3);
		
		bs->squares[i].x = offset_x;
		bs->squares[i].y = offset_y;
		bs->squares[i].width = bs->width/3;
		bs->squares[i].height = bs->width/3;
	}
	
	bs->drawing = gtk_drawing_area_new();
	/* Attaching the drawing area to the rigth table row, column */	
	gtk_table_attach (GTK_TABLE (bs->container), bs->drawing, index%3, index%3+1, index/3, index/3+1,
                    GTK_FILL, GTK_FILL, 0, 0);
	/* I need to realize the widget before drawing */
	gtk_widget_realize(bs->drawing);
	
	/* Connecting button press event and expose event signals to callbacks*/
	g_signal_connect(G_OBJECT (bs->drawing), "button-press-event",
                   G_CALLBACK (button_press), bs);
	
	g_signal_connect (G_OBJECT (bs->drawing), "expose_event",
                    G_CALLBACK (draw_expose_event), bs);
	
	gtk_widget_add_events (GTK_WIDGET (bs->drawing),
            GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);

	gtk_widget_set_size_request(bs->drawing, bs->width, bs->height);
	
	gtk_widget_show(bs->drawing);
	return bs;	
}




struct sudoku_worksheet *sudoku_worksheet_new(guint width, guint height, GtkWidget *container)
{
	struct sudoku_worksheet *board;
	gint i;
	
	board = g_malloc(sizeof(struct sudoku_worksheet));
	board->width = width;
	board->height = height;
	board->changed_since_saved = FALSE;	
	for (i = 0 ; i<81 ; i++ )
	{
		board->s_cells[i] = g_malloc(sizeof(struct sudoku_cell));
		board->s_cells[i]->cell = 0;
		/* Initialise all guess lists */
		board->s_cells[i]->guesses = NULL;
		board->s_cells[i]->fixed = FALSE;
	}
	
	for (i = 0 ; i<9 ; i++)
	{
		board->bs[i] = sudoku_big_square_new (width,height,i,container);
	}
	board->actions = actions_new();
	
	return(board);	
	
}

void sudoku_worksheet_flush_guesses(struct sudoku_worksheet *ws, guint index)
{
	if(ws->s_cells[index]->guesses){
	        g_slist_free(ws->s_cells[index]->guesses);
		ws->s_cells[index]->guesses = NULL;
	}

}

void sudoku_worksheet_add_guess(struct sudoku_worksheet *ws,guint index, guint value)
{
	if(ws->s_cells[index]->cell == 0 && value != 0){
		if(!(check_square(index, value)|| check_row(index, value) || check_column(index,value)))
			guess_add(&(ws->s_cells[index]->guesses),value);
	}else
		g_warning("Cell is already full\n");
}

gboolean sudoku_worksheet_del_guess(struct sudoku_worksheet *ws,guint index, guint value)
{
	g_debug("Deleting guess: %d index: %d\n",value,index);
	return(guess_del(&(ws->s_cells[index]->guesses),value));
}

gboolean sudoku_worksheet_is_in_guess(struct sudoku_worksheet *ws,guint index, guint value)
{
	return(guess_is_in(ws->s_cells[index]->guesses,value));
}

void 
sudoku_big_square_resize(struct sudoku_big_square *bs, guint width, guint height)
{
	gint i;
	
	bs->width = width/3;
	bs->height = height/3;
		
	for(i = 0 ; i < 9 ; i++){
		gint offset_x, offset_y;
		offset_x = i%3 * bs->width/3;
		offset_y = (i/3) * (bs->height/3);
		
		bs->squares[i].x = offset_x;
		bs->squares[i].y = offset_y;
		bs->squares[i].width = bs->width/3;
		bs->squares[i].height = bs->width/3;
	}
	
	gtk_widget_set_size_request(bs->drawing, bs->width, bs->height);
}

void
sudoku_worksheet_resize(struct sudoku_worksheet *board, guint width, guint height)
{
	gint i;
	board->width = width;
	board->height = height;
		
	for (i = 0 ; i<9 ; i++)
	{
		sudoku_big_square_resize (board->bs[i], width, height);
	}
}
