#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "sudoku_sensei/sudoku-pub.h"
#include "sudoku_worksheet.h"


int my_random (int num);

void fill_worksheet_with_sensei(struct sudoku_worksheet **ws)
{
  t_board_p b;
  e_state state;
  int i, j, c, s, n, m;
  int cells[81], symbols[81];

  b = ConstructBasicBoard (3,FALSE);

  if (b)
  {
    srand ((unsigned)time(NULL));  /* Use clock as random seed */

    n = 0;   /* n: number of symbols fixed */

    do
    {
      do                                      /* Choose a cell */
        c = my_random (81);                   /* at random */
      while (GetNumPossValuesOfCell(b,c)==1); /* c: cell number */

      s = my_random (                       /* Choose one of */
            GetNumPossValuesOfCell (b, c)); /* the possible */
                                            /* values */

      m = GetPossValuesOfCell (b, c);  /* Mask with possible */
                                       /* values */
      for (i=j=0; i<9; i++)
        if ((1<<i) & m)        /* Search for the chosen */
        {                      /* possible value in the mask */
          if (j==s)
          {
            s = i;             /* s: chosen symbol number */
            break;
          }

          j ++;
        }

      SetSymbolInCell (b, s, c);  /* Set it, and then */
                                  /* try to solve */
      Solve (b, 0, FALSE);

      state = GetState (b);

      if (state==impossible)   /* This seldom happens, but.. */
      {
        CleanBoard (b);        /* Start from scratch */
        n = 0;
        continue;
      }

      symbols[n] = s;   /* The choice was right */
      cells[n] = c;     /* Store cell-symbol pair */
      printf("n: %d\n",n);
      n ++;
    }
    while (state!=solved);   /* Repeat until solved */

    printf ("Solution:\n");
    for(i=0;i<9;i++){
    	for(j=0;j<9;j++){
		int cell_no = GetCellNumber ( b, i, j);
		printf("%d,%d:%d \n",i,j,GetSymbolOfCell(b,cell_no));
	}
	printf("\n");
    }
    //PrintBoard (b, stdout, NULL, NULL);

    CleanBoard (b);          /* Clean the board and set */
                             /* all the n symbols again */
    for (i=0; i<n; i++)
    	SetSymbolInCell (b, symbols[i], cells[i]);

    for(i=0;i<9;i++){
	for(j=0;j<9;j++){
		int cell_no = GetCellNumber ( b, i, j);
		(*ws)->s_cells[i+9*j]->cell = GetSymbolOfCell(b,cell_no)+1;
		if(GetSymbolOfCell(b,cell_no)+1 != 0)
	  	   (*ws)->s_cells[i+9*j]->fixed = TRUE;
		else
	  	   (*ws)->s_cells[i+9*j]->fixed = FALSE;

		 sudoku_worksheet_flush_guesses(*ws, i+9*j);
	}
      }

    }

    DestroyBoard (b);
}


int my_random (int num)
{
  double d;
  int r;

  d = rand () / (double) RAND_MAX;
  r = (int) (d*num);

  return r<0 ? 0 : r>=num ? num-1 : r;
}
