/*
 * Copyright (C) 2005 Luca De Cicco <ldecicco@gmail.com>
 * Hildonized by Luca De Cicco
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#ifndef IS_HILDON
#include <gpe/init.h>
#endif

#include <unistd.h>
#include <libintl.h>

#include "main_window.h"

#ifdef IS_HILDON
extern HildonProgram *app;
#endif

int
main (int argc, char *argv[])
{
  GtkWidget *window1;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
#ifndef IS_HILDON
 if (gpe_application_init (&argc, &argv) == FALSE)
#else
 if (gtk_init_check (&argc, &argv) == FALSE)
#endif
    exit (1);

  window1 = create_window1 ();

//#ifdef IS_HILDON
//  hildon_program_add_window(app, ri->widget);
//#endif
//  gtk_widget_show (ri->widget);
 // gtk_widget_show (ri->drawing);

  gtk_main ();	
  return 0;
}
