#include "widget.h"

LatitudeGUI::LatitudeGUI(QWidget *parent) :
    QWidget(parent),
    latitude(this),
    gps(this),
    demonio("/opt/linfati.com/bin/latituded"),
    cli(this) {
    qDebug() << "* LatitudeGUI::LatitudeGUI";
    setWindowTitle(tr("LatitudeUpdater"));

    // row 1
    layout_row1 = new QHBoxLayout();
    do_oauth = new QPushButton("Auth");
    do_start = new QPushButton("Start");
    do_stop = new QPushButton("Stop");
    layout_row1->addWidget(do_oauth);
    layout_row1->addWidget(do_start);
    layout_row1->addWidget(do_stop);

    do_oauth->setDisabled(true);
    do_start->setDisabled(true);
    do_stop->setDisabled(true);

    connect(do_oauth, SIGNAL(clicked()), this, SLOT(gl_webauth()) );
    connect(do_start, SIGNAL(clicked()), this, SLOT(gps_start()) );
    connect(do_stop, SIGNAL(clicked()), this, SLOT(gps_stop()) );

    connect(&latitude, SIGNAL(gotToken()), this, SLOT(gl_GotToken()) );
    connect(&latitude, SIGNAL(notToken()), this, SLOT(gl_NotToken()) );
    connect(&latitude, SIGNAL(needAuth()), this, SLOT(gl_needAuth()) );

    connect(&gps, SIGNAL(gotFix()), this, SLOT(set_latitude()) );

    // row 2
    layout_row2 = new QHBoxLayout();
    gps_group = new QButtonGroup();
    gps_method = new QLabel("Method");
    gps_cell = new QRadioButton("Cell Tower");
    gps_both = new QRadioButton("Both");
    gps_agps = new QRadioButton("Only Gps");
    gps_group->addButton(gps_cell);
    gps_group->addButton(gps_both);
    gps_group->addButton(gps_agps);
    layout_row2->addWidget(gps_method);
    layout_row2->addWidget(gps_cell);
    layout_row2->addWidget(gps_both);
    layout_row2->addWidget(gps_agps);

    if ( gps.getPositioningMethod() == "gps" ) gps_agps->setChecked(true);
    if ( gps.getPositioningMethod() == "cell" ) gps_cell->setChecked(true);
    if ( gps.getPositioningMethod() == "all" ) gps_both->setChecked(true);

    connect(gps_cell, SIGNAL(clicked()), this, SLOT(set_method()) );
    connect(gps_both, SIGNAL(clicked()), this, SLOT(set_method()) );
    connect(gps_agps, SIGNAL(clicked()), this, SLOT(set_method()) );

    // row 3
    layout_row3 = new QHBoxLayout();
    gps_to_label = new QLabel("Time Out");
    gps_to_slider = new QSlider(Qt::Horizontal);
    gps_to_slider->setSingleStep(5);
    gps_to_slider->setRange(5, 120);
    gps_to_slider->setValue(gps.getTimeOut());
    gps_to_slider_value = new QLabel(QString("%1 sec.").arg(gps_to_slider->value()));
    layout_row3->addWidget(gps_to_label);
    layout_row3->addWidget(gps_to_slider);
    layout_row3->addWidget(gps_to_slider_value);

    connect(gps_to_slider, SIGNAL(valueChanged(int)), this, SLOT(set_to(int)) );

    // row 4
    layout_row4 = new QHBoxLayout();
    gps_i_label = new QLabel("Interval");

    gps_i_slider = new QSlider(Qt::Horizontal);
    gps_i_slider->setSingleStep(5);
    gps_i_slider->setRange(5, 60);
    gps_i_slider->setValue(gps.getInterval()/60);
    gps_i_slider_value = new QLabel(QString("%1 min.").arg(gps_i_slider->value()));
    layout_row4->addWidget(gps_i_label);
    layout_row4->addWidget(gps_i_slider);
    layout_row4->addWidget(gps_i_slider_value);

    connect(gps_i_slider, SIGNAL(valueChanged(int)), this, SLOT(set_i(int)) );

    // row 5
    layout_row5 = new QHBoxLayout();
    gps_ac_group = new QButtonGroup();
    gps_ac_label = new QLabel("Auto Connect");
    gps_ac_yes = new QRadioButton("Yes");
    gps_ac_not = new QRadioButton("No");
    gps_ac_group->addButton(gps_ac_yes);
    gps_ac_group->addButton(gps_ac_not);
    layout_row5->addWidget(gps_ac_label);
    layout_row5->addWidget(gps_ac_yes);
    layout_row5->addWidget(gps_ac_not);

    if ( latitude.getAutoConnect() == true ) gps_ac_yes->setChecked(true);
    if ( latitude.getAutoConnect() == false ) gps_ac_not->setChecked(true);

    connect(gps_ac_yes, SIGNAL(clicked()), this, SLOT(set_ac_yes()) );
    connect(gps_ac_not, SIGNAL(clicked()), this, SLOT(set_ac_not()) );

    // gui
    layout_gui = new QVBoxLayout();
    layout_gui->addLayout(layout_row1);
    layout_gui->addLayout(layout_row2);
    layout_gui->addLayout(layout_row3);
    layout_gui->addLayout(layout_row4);
    layout_gui->addLayout(layout_row5);

    setLayout(layout_gui);
    latitude.getAccess();
}

