import QtQuick 1.0
import com.meego 1.0

Page {
    id: mainPage
    orientationLock: PageOrientation.LockLandscape
    Column {
        spacing: 16
        Row {
            width: rootWindow.width
            Button {
                id: do_auth
                width: rootWindow.width / 3
                text: "Auth"
                enabled: false
                onClicked: {
                    Qt.openUrlExternally(latitude.getUserAuthorization())
                }
            }
            Button {
                id: do_start
                width: rootWindow.width / 3
                text: "Start"
                enabled: false
                onClicked: {
                    do_start.enabled = false;
                    do_stop.enabled = true;
                    if (!demonio.demonio_start()) {
                        gps.startUpdates()
                    }
                }
            }
            Button {
                id: do_stop
                width: rootWindow.width / 3
                text: "Stop"
                enabled: false
                onClicked: {
                    do_start.enabled = true;
                    do_stop.enabled = false;
                    if (!demonio.demonio_stop()) {
                        gps.stopUpdates(true)
                    }
                }
            }
        }
        Row {
            Label {
                id: method_label
                text: "Method"
                width: rootWindow.width / 4
                anchors.verticalCenter: method_button.verticalCenter
            }
            ButtonRow {
                id: method_button
                width: rootWindow.width * 2 / 3
                Button {
                    id: method_cell
                    text: "Cell Tower"
                    checked: gps.getPositioningMethod() == "cell" ? true : false
                    onClicked: gps.setPositioningMethod("cell")
                }
                Button {
                    id: method_all
                    text: "Both"
                    checked: gps.getPositioningMethod() == "all" ? true : false
                    onClicked: gps.setPositioningMethod("all")
                }
                Button {
                    id: method_agps
                    text: "Only GPS"
                    checked: gps.getPositioningMethod() == "gps" ? true : false
                    onClicked: gps.setPositioningMethod("gps")
                }
            }
        }
        Row {
            Label {
                id: timeout_label
                text: "Time Out"
                width: rootWindow.width / 4
                anchors.verticalCenter: timeout_slider.verticalCenter
            }
            Slider {
                id: timeout_slider
                width: rootWindow.width / 2
                valueIndicatorVisible: true
                minimumValue: 5
                maximumValue: 120
                stepSize: 5
                value: gps.getTimeOut()
            }
            Label {
                id: timeout_value
                text: timeout_slider.value + " seg."
                width: rootWindow.width / 4
                anchors.verticalCenter: timeout_slider.verticalCenter
            }
            Connections {
                target: timeout_slider
                onValueChanged: {
                    timeout_value.text = timeout_slider.value + " seg."
                    gps.setTimeOut(timeout_slider.value)
                }
            }
        }
        Row {
            Label {
                id: interval_label
                text: "Interval"
                width: rootWindow.width / 4
                anchors.verticalCenter: interval_slider.verticalCenter
            }
            Slider {
                id: interval_slider
                width: rootWindow.width / 2
                valueIndicatorVisible: true
                minimumValue: 5
                maximumValue: 60
                stepSize: 5
                value: gps.getInterval() / 60
            }
            Label {
                id: interval_value
                text:  interval_slider.value + " min."
                width: rootWindow.width / 4
                anchors.verticalCenter: interval_slider.verticalCenter
            }
            Connections {
                target: interval_slider
                onValueChanged: {
                    interval_value.text = interval_slider.value + " min."
                    gps.setInterval(interval_slider.value*60)
                }
            }
        }
        Row {
            Label {
                id: connect_label
                text: "Auto Connect"
                width: rootWindow.width / 4
                anchors.verticalCenter: connect_switch.verticalCenter
            }
            Switch {
                id: connect_switch
                width: rootWindow.width / 2
                checked: latitude.getAutoConnect() ? true : false
                onCheckedChanged: {
                    connect_value.text = checked
                    latitude.setAutoConnect(checked)
                }
            }
            Label {
                id: connect_value
                text:  connect_switch.checked
                width: rootWindow.width / 4
                anchors.verticalCenter: connect_switch.verticalCenter
            }
        }

        Connections {
            target: latitude
            onGotToken: {
                do_auth.enabled = false;
                if (demonio.demonio_status()) {
                    do_start.enabled = false;
                    do_stop.enabled = true;
                } else {
                    do_start.enabled = true;
                    do_stop.enabled = false;
                }
            }
        }
        Connections {
            target: latitude
            onNotToken: {
                do_auth.enabled = true;
                do_start.enabled = false;
                do_stop.enabled = false;
                if (!demonio.demonio_stop()) {
                    gps.stopUpdates(true)
                }
            }
        }
        Connections {
            target: latitude
            onNeedAuth: {
                do_auth.enabled = true;
            }
        }

        Connections {
            target: gps
            onGotFix: {
                latitude.setCurrentLocation(gps.getCurrentLatitude(),
                                            gps.getCurrentLongitude(),
                                            gps.getCurrentAccuracy())
                latitude.sendCurrentLocation()
            }
        }
    }
}
