#include "latitudeqml.h"
#include <QtDeclarative/QDeclarativeContext>

LatitudeQML::LatitudeQML(QDeclarativeView *parent) :
    QDeclarativeView(parent),
    latitude(this),
    gps(this),
    demonio(QCoreApplication::applicationDirPath()
        + QDir::separator()
        + "LatitudeUpdaterDaemon"),
    cli(this) {
    qDebug() << "* LatitudeQML::LatitudeQML";

    rootContext()->setContextProperty("latitude", &latitude);
    rootContext()->setContextProperty("gps", &gps);
    rootContext()->setContextProperty("demonio", this);
    setSource(QUrl("qrc:/qml/main.qml"));

    latitude.getAccess();
}
