#ifndef LATITUDE_H
#define LATITUDE_H

#include <QtGui>
#include <QtWebKit>
#ifdef Q_WS_MAEMO_5
#include <QtMaemo5>
#endif
#include "glatitude.h"
#include "gps.h"

class LatitudeGUI : public QMainWindow {
    Q_OBJECT

public:
    LatitudeGUI(QMainWindow *parent = 0);

private slots:
    void set();
    void set_config();
    void latitude_ok();
    void latitude_error();

    void maps_login();
    void mode_buzz();
    void mode_latitude();

    void mode_demonio();

    void config();
    void save_user(QString _user) { setting->setValue("user", _user); }
    void save_pass(QString _pass) { setting->setValue("pass", _pass); }
    void save_interval(QString _inter) { setting->setValue("interval", _inter.toInt()); }
    void save_wait(QString _wait) { setting->setValue("wait", _wait.toInt()); }
    void save_daemon(int _c) { setting->setValue("daemon", (_c == Qt::Checked ? true : false)); }
    void save_gps_cell() { setting->setValue("method", "cell"); }
    void save_gps_both() { setting->setValue("method", "both"); }
    void save_gps_agps() { setting->setValue("method", "agps"); }

private:
    QSettings *setting;
    GpsMaemo5 *gps;
    GoogleLatitude *glatitude;

    QWebView *maps;
    QAction *demonio;
};

#endif // LATITUDE_H
