#ifndef GPS_H
#define GPS_H

#include <QtCore>
#include <QtNetwork>

#ifdef Q_WS_MAEMO_5
extern "C" {
#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>
}
#else
#include <QtNetwork>
#endif // Q_WS_MAEMO_5

class GpsMaemo5 : public QObject {
    Q_OBJECT

signals:
    void fix();

public:
    GpsMaemo5(QObject *parent = 0);
    double get_lat() { return latitude; }
    double get_lon() { return longitude; }
    double get_acc() { return accuracy; }

public slots:
    void refresh();
    void stop();
    void forcestop();
    int config(int i, int w, QString m);

private slots:
#ifdef Q_WS_MAEMO_5
    friend void GpsMaemo5_changed(LocationGPSDevice *device, GpsMaemo5 *gps);
#else
    void gloc_reply(QNetworkReply *r);
#endif // Q_WS_MAEMO_5

private:
    double latitude;
    double longitude;
    double accuracy;
    int interval;
    int wait;
    QString method;
    bool emitfix;
    bool stopgps;
#ifdef Q_WS_MAEMO_5
    LocationGPSDControl *control;
    LocationGPSDevice *device;
#else
    QUrl urlloc;
    QNetworkAccessManager *worker;
#endif // Q_WS_MAEMO_5
};

#ifdef Q_WS_MAEMO_5
void GpsMaemo5_changed(LocationGPSDevice *device, GpsMaemo5 *gps);
#endif // Q_WS_MAEMO_5

#endif // GPS_H
