#include "daemon.h"

Daemon::Daemon(QObject *parent) : QObject(parent) {
    setting = new QSettings();
    gps = new GpsMaemo5(this);
    glatitude = new GoogleLatitude(this);

    connect(gps, SIGNAL(fix()), this, SLOT(set()));
    connect(glatitude, SIGNAL(glat_ok()), this, SLOT(daemon_ok()));
    connect(glatitude, SIGNAL(glat_error()), this, SLOT(daemon_error()));

    set_config();
    if ( 0 ) gps->config(15, 3, 0);

    gps->refresh();
}

void Daemon::set() {
    qDebug() << "Daemon: set";
    set_config();
    glatitude->update(gps->get_lat(),
                      gps->get_lon(),
                      gps->get_acc());
}

void Daemon::set_config() {
    qDebug() << "Daemon: set_config";
    glatitude->set_login(setting->value("user","my_username").toString(),
                         setting->value("pass","my_password").toString());

    gps->config(setting->value("interval",1800).toInt(),
                setting->value("wait",30).toInt(),
                setting->value("usegps",false).toBool());
}

void Daemon::daemon_ok() {
    qDebug() << "Daemon: ok";
}

void Daemon::daemon_error() {
    qDebug() << "Daemon: no auth";
    QCoreApplication::exit();
}
