#include "gps.h"

GpsMaemo5::GpsMaemo5(QObject *parent) :
        QObject(parent),
        latitude(0), longitude(0), accuracy(0),
        interval(1800), wait(30), usegps(false),
        emitfix(false), stopgps(true) {
#ifdef Q_WS_MAEMO_5
    control = location_gpsd_control_get_default();
    device = (LocationGPSDevice*) g_object_new(LOCATION_TYPE_GPS_DEVICE, NULL);
    g_signal_connect(device, "changed", G_CALLBACK(GpsMaemo5_changed), this);
#else
    urlloc = QUrl::fromEncoded("http://www.google.com/loc/json");
    worker = new QNetworkAccessManager();
    connect(worker, SIGNAL(finished(QNetworkReply *)), this, SLOT(gloc_reply(QNetworkReply *)));
#endif // Q_WS_MAEMO_5
}

void GpsMaemo5::refresh() {
    if ( stopgps ) return;
    qDebug() << "GpsMaemo5: refresh";

    QTimer::singleShot(interval*1000, this, SLOT(refresh()));
    QTimer::singleShot(wait*1000, this, SLOT(stop()));

#ifdef Q_WS_MAEMO_5
    g_object_set(G_OBJECT(control), "preferred-method", LOCATION_METHOD_ACWP, NULL);
    if (usegps) {
        g_object_set(G_OBJECT(control), "preferred-method", LOCATION_METHOD_AGNSS, NULL);
    }
    location_gpsd_control_start(control);
#else
    worker->post(QNetworkRequest(urlloc), QByteArray("{version:\"1.1.0\"}"));
#endif // Q_WS_MAEMO_5
}

void GpsMaemo5::stop() {
    qDebug() << "GpsMaemo5: stop";
#ifdef Q_WS_MAEMO_5
    location_gpsd_control_stop(control);
#else
#endif // Q_WS_MAEMO_5
    if (emitfix) {
        emitfix = false;
        emit fix();
    }
}

void GpsMaemo5::forcestop() {
    qDebug() << "GpsMaemo5: forcestop";
    stopgps = true;
}

int GpsMaemo5::config(int i, int w, bool g) {
    qDebug() << "GpsMaemo5: config";
    stopgps = false;
    interval = i;
    wait = w;
    usegps = g;
    return 0;
}

#ifdef Q_WS_MAEMO_5
void GpsMaemo5_changed(LocationGPSDevice *device, GpsMaemo5 *gps) {
    if (device->fix) {
        if (device->fix->fields) {
            g_print("GpsMaemo5 lat %f lon %f eph %f\n", gps->device->fix->latitude, gps->device->fix->longitude, gps->device->fix->eph/100.);
            gps->latitude = gps->device->fix->latitude;
            gps->longitude = gps->device->fix->longitude;
            gps->accuracy = gps->device->fix->eph/100.;
            gps->emitfix = true;
        }
    }
}
#else
void GpsMaemo5::gloc_reply(QNetworkReply *r) {
    if ( r->url() == urlloc ) {
        QString loc = r->readAll();
        QRegExp regexp ("\\{\"latitude\":(.*),\"longitude\":(.*),\"accuracy\":(.*)\\}");
        regexp.setMinimal(1);
        regexp.indexIn(loc, 1);
        latitude = regexp.capturedTexts().at(1).toDouble();
        longitude = regexp.capturedTexts().at(2).toDouble();
        accuracy = regexp.capturedTexts().at(3).toDouble();
        if ( accuracy > 100000 ) accuracy = 100000;
        qDebug() << "GpsIP lat" << latitude << "lon" << longitude << "acc" << accuracy;
        emitfix = true;
    } else {
        qDebug() << "GpsIP Error url" << r->url();
        qDebug() << r->rawHeaderList();
        qDebug() << r->readAll();
    }
}
#endif // Q_WS_MAEMO_5
