#include "latitude.h"
#include "daemon.h"

int main(int argc, char *argv[]) {
    QCoreApplication::setOrganizationName("linfati");
    QCoreApplication::setOrganizationDomain("linfati.com");
    QCoreApplication::setApplicationName("GoogleLatitude");
    QCoreApplication::setApplicationVersion("0.4.5");

    if ( QString(argv[0]).contains("GoogleLatitudeDaemon") ) {
        QCoreApplication app(argc, argv);
        qDebug() << "main: Daemon";
        Daemon *demonio;
        demonio = new Daemon();
        app.exec();
    } else if ( QString(argv[0]).contains("GoogleLatitudeGUI") ) {
        QApplication app(argc, argv);
        qDebug() << "main: GUI";
        LatitudeGUI *gui = new LatitudeGUI();
        gui->show();
        app.exec();
    } else {
        QApplication app(argc, argv);
        qDebug() << "main: default";
        LatitudeGUI *gui = new LatitudeGUI();
        gui->show();
        app.exec();
    }

    return 0;
}
