#ifndef GLATITUDE_H
#define GLATITUDE_H

#include <QtNetwork>

class GoogleLatitude : public QObject {
    Q_OBJECT

signals:
    void OK();
    void ERROR();

public:
    GoogleLatitude(QObject *parent = 0);
    void login(QString username, QString password);
    void set(double la, double lo, double ac=1000.);
    void freq(int f=120);
    void reset();
    double get_lat() { return latitude; }
    double get_lon() { return longitude; }
    double get_acc() { return accuracy; }

private slots:
    void finishedreply(QNetworkReply *r);

private:
    // info
    QString user;
    QString pass;
    double latitude;
    double longitude;
    double accuracy;
    int interval;
    // stuff
    QNetworkAccessManager *worker;
    QUrl urllogin;
    QUrl urldologin;
    QUrl urlupdate;
    qint64 lastupdate;
    bool login_error;
};

#endif // GLATITUDE_H
