#include "latitude.h"

LatitudeGUI::LatitudeGUI(QMainWindow *parent) : QMainWindow(parent) {
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    setWindowTitle(tr("Google Latitude Updater"));

    setting = new QSettings();

    // login input
    QDialog *dialoglogin = new QDialog(this);
    QLineEdit *login_user = new QLineEdit(setting->value("user","my_username").toString());
    QLineEdit *login_pass = new QLineEdit(setting->value("pass","my_password").toString());
    login_pass->setEchoMode(QLineEdit::Password);
    QFormLayout *layout_login = new QFormLayout();
    layout_login->addRow(tr("&Username"), login_user);
    layout_login->addRow(tr("&Password"), login_pass);
    connect(login_user, SIGNAL(textEdited(QString)), this, SLOT(save_user(QString)));
    connect(login_pass, SIGNAL(textEdited(QString)), this, SLOT(save_pass(QString)));
    connect(login_user, SIGNAL(returnPressed()), login_pass, SLOT(setFocus()));
    connect(login_pass, SIGNAL(returnPressed()), dialoglogin, SLOT(accept()));
    dialoglogin->setLayout(layout_login);
    dialoglogin->exec();

    // GUI
    url = QUrl::fromEncoded("https://www.google.com/accounts/ServiceLogin?service=friendview&continue=http://www.google.com/maps/m?mode=latitude");
    maps = new QWebView();
    connect(maps, SIGNAL(loadFinished(bool)), this, SLOT(maps_login()));
    maps->load(url);
    menuBar()->addAction(tr("&Latitude"), this, SLOT(mode_latitude()));
    menuBar()->addAction(tr("&Buzz"), this, SLOT(mode_buzz()));

    // updater
    glatitude = new GoogleLatitude(this);
    gps = new GpsMaemo5(this);
    connect(gps, SIGNAL(fix()), this, SLOT(set()));
    connect(glatitude, SIGNAL(OK()), this, SLOT(latitude_OK()));
    connect(glatitude, SIGNAL(ERROR()), this, SLOT(latitude_ERROR()));

    // show it
    setCentralWidget(maps);
}

void LatitudeGUI::set() {
    QMaemo5InformationBox::information(this, "New gps position", 1000);
    glatitude->login(setting->value("user","my_username").toString(),
                     setting->value("pass","my_password").toString());
    glatitude->set(gps->get_lat(),
                   gps->get_lon(),
                   gps->get_acc());
}

void LatitudeGUI::latitude_OK() {
    QMaemo5InformationBox::information(this, "Location Sent!", 1000);
}

void LatitudeGUI::latitude_ERROR() {
    QMaemo5InformationBox::information(this, "Error in Authentification !", 3000);
}

void LatitudeGUI::save_user(QString _user) {
    setting->setValue("user", _user);
}
void LatitudeGUI::save_pass(QString _pass) {
    setting->setValue("pass", _pass);
}

void LatitudeGUI::mode_buzz() {
    maps->load(QUrl::fromEncoded("http://www.google.com/maps/m?l-view=map&l-lci=m,com.google.latitudepublicupdates&ac=f,s,l"));
}

void LatitudeGUI::mode_latitude() {
    maps->load(QUrl::fromEncoded("https://www.google.com/accounts/ServiceLogin?service=friendview&continue=http://www.google.com/maps/m?mode=latitude"));
}

void LatitudeGUI::maps_login() {
    if ( maps->url() == url ) {
        maps->page()->mainFrame()->evaluateJavaScript(
                QString("document.getElementById('Email').value = \"%1\";").arg(
                        setting->value("user").toString()));
        maps->page()->mainFrame()->evaluateJavaScript(
                QString("document.getElementById('Passwd').value = \"%1\";").arg(
                        setting->value("pass").toString()));
        maps->page()->mainFrame()->evaluateJavaScript("document.getElementById('gaia_loginform').submit();");
    }
}
