#ifndef GPS_H
#define GPS_H

#include <QObject>

extern "C" {
#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>
}

class GpsMaemo5 : public QObject {
    Q_OBJECT

signals:
    void fix();

public:
    GpsMaemo5(QObject *parent = 0);
    double get_lat() { return latitude; }
    double get_lon() { return longitude; }
    double get_acc() { return accuracy; }
    friend void GpsMaemo5_changed(LocationGPSDevice *device, GpsMaemo5 *gps);

private:
    double latitude;
    double longitude;
    double accuracy;

    GMainLoop *loop;
    LocationGPSDControl *control;
    LocationGPSDevice *device;
};

void GpsMaemo5_changed(LocationGPSDevice *device, GpsMaemo5 *gps);

#endif // GPS_H
